/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.TreeNodeDao;
import de.terrestris.shoguncore.helper.IdHelper;
import de.terrestris.shoguncore.model.tree.TreeFolder;
import de.terrestris.shoguncore.model.tree.TreeNode;
import de.terrestris.shoguncore.service.PermissionAwareCrudService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="treeNodeService")
public class TreeNodeService<E extends TreeNode, D extends TreeNodeDao<E>>
extends PermissionAwareCrudService<E, D> {
    public TreeNodeService() {
        this(TreeNode.class);
    }

    protected TreeNodeService(Class<E> entityClass) {
        super(entityClass);
    }

    public E cloneAndPersistTreeNode(E node) throws Exception {
        if (node == null) {
            throw new Exception("Node to clone must not be null.");
        }
        if ((node = (TreeNode)((TreeNodeDao)this.dao).unproxy(node)) instanceof TreeFolder) {
            List<TreeNode> children = ((TreeFolder)node).getChildren();
            ArrayList<TreeNode> clonedChildren = new ArrayList<TreeNode>();
            for (TreeNode childNode : children) {
                clonedChildren.add(this.cloneAndPersistTreeNode(childNode));
            }
            ((TreeFolder)node).setChildren(children);
        }
        ((TreeNodeDao)this.dao).evict(node);
        IdHelper.setIdOnPersistentObject(node, null);
        ((TreeNodeDao)this.dao).saveOrUpdate(node);
        return node;
    }

    @Override
    @Autowired
    @Qualifier(value="treeNodeDao")
    public void setDao(D dao) {
        this.dao = dao;
    }
}

