/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor;

import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class BasicAuthHeaderRequest
extends MutableHttpServletRequest {
    public final String encoding;

    public BasicAuthHeaderRequest(HttpServletRequest request, String user, String password) {
        super(request);
        this.encoding = "Basic " + Base64.getEncoder().encodeToString(user.concat(":").concat(password).getBytes());
    }

    @Override
    public String getHeader(String name) {
        if (name.equals("Authorization")) {
            return this.encoding;
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (name.equals("Authorization")) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.encoding);
            return Collections.enumeration(list);
        }
        return super.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList list = Collections.list(super.getHeaderNames());
        list.add("Authorization");
        return Collections.enumeration(list);
    }
}

