/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor;

import de.terrestris.shoguncore.util.enumeration.OgcEnum;
import de.terrestris.shoguncore.util.interceptor.CachedServletInputStream;
import de.terrestris.shoguncore.util.interceptor.InterceptorException;
import de.terrestris.shoguncore.util.interceptor.OgcXmlUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class MutableHttpServletRequest
extends HttpServletRequestWrapper {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Logger LOG = LogManager.getLogger(MutableHttpServletRequest.class);
    private Map<String, String[]> customParameters;
    private Map<String, String> customHeaders;
    private String customRequestURI;
    private ByteArrayOutputStream cachedInputStream;

    public MutableHttpServletRequest(HttpServletRequest request) {
        super(request);
        this.customRequestURI = request.getRequestURI();
        this.customParameters = new HashMap<String, String[]>(request.getParameterMap());
        this.customHeaders = new HashMap<String, String>();
    }

    public static String getRequestParameterValue(HttpServletRequest httpServletRequest, String[] keys) throws InterceptorException, IOException {
        String key;
        String value = "";
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && !StringUtils.isNotEmpty((CharSequence)(value = MutableHttpServletRequest.getRequestParameterValue(httpServletRequest, key = stringArray[i]))); ++i) {
        }
        return value;
    }

    public static String getRequestParameterValue(HttpServletRequest httpServletRequest, String parameter) throws InterceptorException, IOException {
        LOG.trace("Finding the request parameter [" + parameter + "]");
        String value = "";
        Map queryParams = httpServletRequest.getParameterMap();
        if (!queryParams.isEmpty()) {
            LOG.trace("The request contains query parameters (GET or POST).");
            TreeMap params = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            params.putAll(queryParams);
            if (params.containsKey(parameter)) {
                value = StringUtils.join((Object[])((Object[])params.get(parameter)), (String)",");
            }
        } else {
            String xml = OgcXmlUtil.getRequestBody(httpServletRequest);
            if (!StringUtils.isEmpty((CharSequence)xml)) {
                LOG.trace("The request contains a POST body.");
                Document document = OgcXmlUtil.getDocumentFromString(xml);
                if (parameter.equalsIgnoreCase(OgcEnum.Service.SERVICE.toString())) {
                    value = OgcXmlUtil.getPathInDocument(document, "/*/@service");
                } else if (parameter.equalsIgnoreCase(OgcEnum.Operation.OPERATION.toString())) {
                    value = OgcXmlUtil.getPathInDocument(document, "name(/*)");
                    if (value.contains(":")) {
                        value = value.split(":")[1];
                    }
                } else if (Arrays.asList(OgcEnum.EndPoint.getAllValues()).contains(parameter) && StringUtils.isEmpty((CharSequence)(value = OgcXmlUtil.getPathInDocument(document, "//TypeName/text() | //TypeNames/text() | //GetCoverage/Identifier/text()")))) {
                    value = OgcXmlUtil.getPathInDocument(document, "//@typeName | //@typeNames");
                }
            } else {
                LOG.error("No body found in the request.");
            }
        }
        LOG.trace("Found the request parameter value: " + value);
        return value;
    }

    public void setRequestURI(String url) {
        this.customRequestURI = url;
    }

    public void setRequestURI(URI uri) {
        this.customRequestURI = uri.toString();
    }

    public String getRequestURI() {
        if (this.customRequestURI != null) {
            return this.customRequestURI;
        }
        HttpServletRequest request = (HttpServletRequest)super.getRequest();
        return request.getRequestURI();
    }

    public void setParameter(String key, String[] value) {
        if (!StringUtils.isEmpty((CharSequence)this.getParameter(key))) {
            this.removeParameter(key);
        }
        this.addParameter(key, value);
    }

    public void setParameter(String key, String value) {
        if (!StringUtils.isEmpty((CharSequence)this.getParameter(key))) {
            this.removeParameter(key);
        }
        this.addParameter(key, value);
    }

    public void setHeader(String key, String value) {
        if (!StringUtils.isEmpty((CharSequence)this.getHeader(key))) {
            this.removeHeader(key);
        }
        this.customHeaders.put(key, value);
    }

    public void addParameter(String key, String[] value) {
        this.customParameters.put(key, value);
    }

    public void addParameter(String key, String value) {
        String[] values = value.split(",", -1);
        this.customParameters.put(key, values);
    }

    public void removeParameter(String key) {
        if (this.customParameters.get(key) != null) {
            this.customParameters.remove(key);
        }
    }

    public void removeHeader(String key) {
        if (this.customHeaders.get(key) != null) {
            this.customHeaders.remove(key);
        }
    }

    public String getParameter(String key) {
        if (this.customParameters.containsKey(key)) {
            return StringUtils.join((Object[])this.customParameters.get(key), (String)",");
        }
        HttpServletRequest request = (HttpServletRequest)super.getRequest();
        return request.getParameter(key);
    }

    public Map<String, String[]> getParameterMap() {
        return this.customParameters;
    }

    public String getHeader(String name) {
        String headerValue = this.customHeaders.get(name);
        if (headerValue != null) {
            return headerValue;
        }
        return ((HttpServletRequest)this.getRequest()).getHeader(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.cachedInputStream == null) {
            this.cacheInputStream();
        }
        return new CachedServletInputStream(this.cachedInputStream);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private void cacheInputStream() throws IOException {
        this.cachedInputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)super.getInputStream(), (OutputStream)this.cachedInputStream);
    }

    public void setInputStream(String body) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(body.getBytes(DEFAULT_CHARSET));){
            this.cachedInputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)stream, (OutputStream)this.cachedInputStream);
        }
        catch (IOException e) {
            LOG.error("Exception on writing InputStream.", (Throwable)e);
        }
    }

    public void setInputStream(InputStream stream) {
        try {
            this.cachedInputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)stream, (OutputStream)this.cachedInputStream);
        }
        catch (IOException e) {
            LOG.error("Exception on writing InputStream.", (Throwable)e);
        }
    }

    public String getParameterIgnoreCase(String name) {
        for (Map.Entry<String, String[]> entry : this.customParameters.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return StringUtils.join((Object[])entry.getValue(), (String)",");
        }
        return null;
    }
}

