/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.naming;

import de.terrestris.shoguncore.util.dialect.ShogunCoreOracleDialect;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class PhysicalNamingStrategyShogunCore
implements PhysicalNamingStrategy,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int LENGTH_LIMIT_ORACLE = 30;
    protected static final int LENGTH_LIMIT_POSTGRESQL = 63;
    @Autowired(required=false)
    @Qualifier(value="tablePrefix")
    private String tablePrefix;

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalTableName(Identifier tableIdentifier, JdbcEnvironment context) {
        return this.convertToLimitedLowerCase(context, tableIdentifier, this.tablePrefix);
    }

    public Identifier toPhysicalColumnName(Identifier columnIdentifier, JdbcEnvironment context) {
        return this.convertToLimitedLowerCase(context, columnIdentifier, null);
    }

    protected Identifier convertToLimitedLowerCase(JdbcEnvironment context, Identifier identifier, String prefix) {
        String identifierText = identifier.getText();
        if (prefix != null) {
            identifierText = prefix + identifierText;
        }
        identifierText = identifierText.toLowerCase();
        Integer lengthLimit = this.getIdentifierLengthLimit(context);
        if (lengthLimit != null && identifierText.length() > lengthLimit) {
            identifierText = StringUtils.substring((String)identifierText, (int)0, (int)lengthLimit);
        }
        return Identifier.toIdentifier((String)identifierText);
    }

    protected Integer getIdentifierLengthLimit(JdbcEnvironment context) {
        String dialectName = context.getDialect().getClass().getSimpleName();
        if (dialectName.startsWith("Oracle")) {
            return 30;
        }
        if (context.getDialect() instanceof ShogunCoreOracleDialect) {
            return 30;
        }
        if (dialectName.startsWith("PostgreSQL")) {
            return 63;
        }
        return null;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }
}

