package de.terrestris.shoguncore.rest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import de.terrestris.shoguncore.dao.RoleDao;
import de.terrestris.shoguncore.model.Role;
import de.terrestris.shoguncore.service.RoleService;

/**
 * @author Andre Henn
 */
@RestController
@RequestMapping("/roles")
public class RoleRestController<E extends Role, D extends RoleDao<E>, S extends RoleService<E, D>>
    extends AbstractRestController<E, D, S> {

    /**
     * Default constructor, which calls the type-constructor
     */
    @SuppressWarnings("unchecked")
    public RoleRestController() {
        this((Class<E>) Role.class);
    }

    /**
     * Constructor that sets the concrete entity class for the controller.
     * Subclasses MUST call this constructor.
     */
    protected RoleRestController(Class<E> entityClass) {
        super(entityClass);
    }

    /**
     * We have to use {@link Qualifier} to define the correct service here.
     * Otherwise, spring can not decide which service has to be autowired here
     * as there are multiple candidates.
     */
    @Override
    @Autowired
    @Qualifier("roleService")
    public void setService(S service) {
        this.service = service;
    }
}
