/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.terrestris.shoguncore.converter.TreeFolderIdResolver;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.tree.TreeFolder;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table
@Inheritance(strategy=InheritanceType.JOINED)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class TreeNode
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private String text;
    @ManyToOne
    @JoinColumn(name="PARENTFOLDER_ID")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", resolver=TreeFolderIdResolver.class)
    @JsonIdentityReference(alwaysAsId=true)
    @JsonProperty(value="parentId")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private TreeFolder parentFolder;
    private int index;
    private boolean root = false;
    private boolean leaf = true;
    private Boolean checked;
    private boolean expandable;
    private boolean expanded;
    private String icon;
    private String iconCls;
    private String qTip;
    private String qTitle;

    public TreeNode() {
    }

    public TreeNode(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TreeFolder getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(TreeFolder parentFolder) {
        this.parentFolder = parentFolder;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public Boolean isChecked() {
        return this.checked;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIconCls() {
        return this.iconCls;
    }

    public void setIconCls(String iconCls) {
        this.iconCls = iconCls;
    }

    public String getqTip() {
        return this.qTip;
    }

    public void setqTip(String qTip) {
        this.qTip = qTip;
    }

    public String getqTitle() {
        return this.qTitle;
    }

    public void setqTitle(String qTitle) {
        this.qTitle = qTitle;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 5).appendSuper(super.hashCode()).append((Object)this.getText()).append(this.getIndex()).append(this.isRoot()).append(this.isLeaf()).append((Object)this.isChecked()).append(this.isExpandable()).append(this.isExpanded()).append((Object)this.getIcon()).append((Object)this.getIconCls()).append((Object)this.getqTip()).append((Object)this.getqTitle()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TreeNode)) {
            return false;
        }
        TreeNode other = (TreeNode)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getText(), (Object)other.getText()).append(this.getIndex(), other.getIndex()).append(this.isLeaf(), other.isLeaf()).append(this.isRoot(), other.isRoot()).append((Object)this.isChecked(), (Object)other.isChecked()).append(this.isExpandable(), other.isExpandable()).append(this.isExpanded(), other.isExpanded()).append((Object)this.getIcon(), (Object)other.getIcon()).append((Object)this.getIconCls(), (Object)other.getIconCls()).append((Object)this.getqTip(), (Object)other.getqTip()).append((Object)this.getqTitle(), (Object)other.getqTitle()).isEquals();
    }
}

