/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.wps;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.terrestris.shoguncore.model.PersistentObject;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="classType")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class WpsParameter
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private final String classType;
    private String valueType;
    private String displayName;
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="WPSPARAM_ID")})
    @Column(name="FORMAT_NAME")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Set<String> supportedFormats = new HashSet<String>();
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="WPSPARAM_ID")})
    @Column(name="GEOMTYPE_NAME")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Set<String> supportedGeometryTypes = new HashSet<String>();

    public WpsParameter() {
        this.classType = this.getClass().getName();
    }

    public String getClassType() {
        return this.classType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Set<String> getSupportedFormats() {
        return this.supportedFormats;
    }

    public void setSupportedFormats(Set<String> supportedFormats) {
        this.supportedFormats = supportedFormats;
    }

    public Set<String> getSupportedGeometryTypes() {
        return this.supportedGeometryTypes;
    }

    public void setSupportedGeometryTypes(Set<String> supportedGeometryTypes) {
        this.supportedGeometryTypes = supportedGeometryTypes;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(19, 47).appendSuper(super.hashCode()).append((Object)this.getValueType()).append((Object)this.getDisplayName()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WpsParameter)) {
            return false;
        }
        WpsParameter other = (WpsParameter)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getValueType(), (Object)other.getValueType()).append((Object)this.getDisplayName(), (Object)other.getDisplayName()).isEquals();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).appendSuper(super.toString()).append("valueType", (Object)this.valueType).append("displayName", (Object)this.displayName).toString();
    }
}

