/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.AbstractTokenDao;
import de.terrestris.shoguncore.model.token.Token;
import de.terrestris.shoguncore.service.PermissionAwareCrudService;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.joda.time.DateTime;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractTokenService<E extends Token, D extends AbstractTokenDao<E>>
extends PermissionAwareCrudService<E, D> {
    public AbstractTokenService() {
        this(Token.class);
    }

    protected AbstractTokenService(Class<E> entityClass) {
        super(entityClass);
    }

    @Transactional(readOnly=true)
    public E findByTokenValue(String token) {
        SimpleExpression criteria = Restrictions.eq((String)"token", (Object)token);
        Token userToken = (Token)((AbstractTokenDao)this.dao).findByUniqueCriteria(new Criterion[]{criteria});
        return (E)userToken;
    }

    @Transactional(readOnly=true)
    public void validateToken(E token) throws Exception {
        if (token == null) {
            throw new Exception("The provided token is null.");
        }
        DateTime expirationDate = (DateTime)((Token)token).getExpirationDate();
        String tokenValue = ((Token)token).getToken();
        if (expirationDate.isBeforeNow()) {
            throw new Exception("The token '" + tokenValue + "' expired on '" + expirationDate + "'");
        }
    }
}

