/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.model.interceptor.InterceptorRule;
import de.terrestris.shoguncore.service.InterceptorRuleService;
import de.terrestris.shoguncore.util.enumeration.HttpEnum;
import de.terrestris.shoguncore.util.enumeration.OgcEnum;
import de.terrestris.shoguncore.util.http.HttpUtil;
import de.terrestris.shoguncore.util.interceptor.InterceptorException;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.OgcMessage;
import de.terrestris.shoguncore.util.interceptor.OgcMessageDistributor;
import de.terrestris.shoguncore.util.interceptor.OgcXmlUtil;
import de.terrestris.shoguncore.util.model.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class GeoServerInterceptorService {
    private static final Logger LOG = LogManager.getLogger(GeoServerInterceptorService.class);
    private Properties geoServerNameSpaces;
    private static final String[] FORWARD_REQUEST_HEADER_KEYS = new String[]{"Authorization"};
    private static final String[] FORWARD_RESPONSE_HEADER_KEYS = new String[]{"Content-Type", "Content-Disposition", "Content-Language", "geowebcache-cache-result", "geowebcache-crs", "geowebcache-gridset", "geowebcache-tile-bounds", "geowebcache-tile-index", "geowebcache-miss-reason"};
    private final String WMS_REFLECT_ENDPOINT = "/reflect";
    private final String USE_REFLECT_PARAM = "useReflect";
    @Autowired
    OgcMessageDistributor ogcMessageDistributor;
    @Autowired
    InterceptorRuleService<InterceptorRule, ?> interceptorRuleService;

    public Response interceptGeoServerRequest(HttpServletRequest request) throws InterceptorException, URISyntaxException, HttpException, IOException {
        return this.interceptGeoServerRequest(request, Optional.empty());
    }

    public Response interceptGeoServerRequest(HttpServletRequest request, Optional<String> endpoint) throws InterceptorException, URISyntaxException, HttpException, IOException {
        MutableHttpServletRequest mutableRequest = new MutableHttpServletRequest(request);
        if (endpoint.isPresent()) {
            mutableRequest.addParameter("CUSTOM_ENDPOINT", endpoint.get());
            mutableRequest.addParameter("CONTEXT_PATH", request.getContextPath());
        }
        OgcMessage message = this.getOgcMessage(mutableRequest);
        boolean useWmsReflector = this.shouldReflectEndpointBeCalled(mutableRequest, message);
        URI geoServerBaseUri = this.getGeoServerBaseURI(message, useWmsReflector);
        mutableRequest.setRequestURI(geoServerBaseUri);
        mutableRequest = this.ogcMessageDistributor.distributeToRequestInterceptor(mutableRequest, message);
        Response response = GeoServerInterceptorService.sendRequest(mutableRequest);
        Response interceptedResponse = this.ogcMessageDistributor.distributeToResponseInterceptor(mutableRequest, response, message);
        HttpHeaders forwardingHeaders = GeoServerInterceptorService.getResponseHeadersToForward(interceptedResponse.getHeaders());
        interceptedResponse.setHeaders(forwardingHeaders);
        return interceptedResponse;
    }

    private boolean shouldReflectEndpointBeCalled(MutableHttpServletRequest mutableRequest, OgcMessage message) throws InterceptorException, IOException {
        boolean useReflect = false;
        if (message.getService() != OgcEnum.ServiceType.WMS) {
            return useReflect;
        }
        String value = MutableHttpServletRequest.getRequestParameterValue((HttpServletRequest)mutableRequest, "useReflect");
        useReflect = Boolean.valueOf(value);
        if (useReflect) {
            LOG.info("Parameter useReflectfound in request. Will use WMS reflector endpoint of GeoServer.");
        }
        return useReflect;
    }

    private OgcMessage getOgcMessage(MutableHttpServletRequest mutableRequest) throws InterceptorException, IOException {
        LOG.trace("Building the OGC message from the given request.");
        OgcMessage ogcMessage = new OgcMessage();
        String requestService = MutableHttpServletRequest.getRequestParameterValue((HttpServletRequest)mutableRequest, OgcEnum.Service.SERVICE.toString());
        String requestOperation = MutableHttpServletRequest.getRequestParameterValue((HttpServletRequest)mutableRequest, OgcEnum.Operation.OPERATION.toString());
        String requestEndPoint = MutableHttpServletRequest.getRequestParameterValue((HttpServletRequest)mutableRequest, OgcEnum.EndPoint.getAllValues());
        if (StringUtils.isEmpty((CharSequence)requestService) || StringUtils.isEmpty((CharSequence)requestOperation) || StringUtils.isEmpty((CharSequence)requestEndPoint)) {
            if (!StringUtils.isEmpty((CharSequence)requestEndPoint) && !StringUtils.isEmpty((CharSequence)MutableHttpServletRequest.getRequestParameterValue((HttpServletRequest)mutableRequest, "useReflect"))) {
                LOG.trace("Will use WMS reflector endpoint of GeoServer");
                requestService = OgcEnum.ServiceType.WMS.toString();
                requestOperation = OgcEnum.OperationType.GET_MAP.toString();
            } else {
                throw new InterceptorException("Couldn't find all required OGC parameters (SERVICE, REQUEST, ENDPOINT). Please check the validity of the request.");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)requestService)) {
            ogcMessage.setService(OgcEnum.ServiceType.fromString(requestService));
            LOG.trace("Successfully set the service: " + (Object)((Object)OgcEnum.ServiceType.fromString(requestService)));
        } else {
            LOG.debug("No service found.");
        }
        if (StringUtils.isNotEmpty((CharSequence)requestOperation)) {
            ogcMessage.setOperation(OgcEnum.OperationType.fromString(requestOperation));
            LOG.trace("Successfully set the operation: " + (Object)((Object)OgcEnum.OperationType.fromString(requestOperation)));
        } else {
            LOG.debug("No operation found.");
        }
        if (StringUtils.isNotEmpty((CharSequence)requestEndPoint)) {
            ogcMessage.setEndPoint(requestEndPoint);
            LOG.trace("Successfully set the endPoint: " + requestEndPoint);
        } else {
            LOG.debug("No endPoint found.");
        }
        InterceptorRule mostSpecificRequestRule = this.getMostSpecificRule(requestService, requestOperation, requestEndPoint, HttpEnum.EventType.REQUEST.toString());
        InterceptorRule mostSpecificResponseRule = this.getMostSpecificRule(requestService, requestOperation, requestEndPoint, HttpEnum.EventType.RESPONSE.toString());
        if (mostSpecificRequestRule != null) {
            ogcMessage.setRequestRule(mostSpecificRequestRule.getRule());
            LOG.trace("Successfully set the requestRule: " + (Object)((Object)mostSpecificRequestRule.getRule()));
        } else {
            LOG.debug("No interceptor rule found for the request.");
        }
        if (mostSpecificResponseRule != null) {
            ogcMessage.setResponseRule(mostSpecificResponseRule.getRule());
            LOG.trace("Successfully set the responseRule: " + (Object)((Object)mostSpecificResponseRule.getRule()));
        } else {
            LOG.debug("No interceptor rule found for the response.");
        }
        LOG.trace("Successfully build the OGC message: " + ogcMessage);
        return ogcMessage;
    }

    private InterceptorRule getMostSpecificRule(String requestService, String requestOperation, String requestEndPoint, String ruleEvent) throws InterceptorException {
        OgcEnum.ServiceType service = OgcEnum.ServiceType.fromString(requestService);
        OgcEnum.OperationType operation = OgcEnum.OperationType.fromString(requestOperation);
        String endPoint = requestEndPoint;
        LOG.trace("Finding the most specific interceptor rule for: \n  * Event: " + ruleEvent + "\n  * Service: " + (Object)((Object)service) + "\n  * Operation: " + (Object)((Object)operation) + "\n  * EndPoint: " + endPoint);
        List<InterceptorRule> interceptorRules = this.interceptorRuleService.findAllRulesForServiceAndEvent(requestService, ruleEvent);
        LOG.trace("Got " + interceptorRules.size() + " rule(s) from database.");
        if (LOG.isTraceEnabled()) {
            for (InterceptorRule interceptorRule : interceptorRules) {
                LOG.trace("Returned rule is: " + interceptorRule);
            }
        }
        LOG.trace("Evaluating the given rules for the most specific one:");
        HashMap ruleMap = new HashMap();
        interceptorRules.stream().forEach(rule -> {
            int score = 0;
            if (!Objects.equals(rule.getEndPoint(), null) && !Objects.equals(rule.getEndPoint(), endPoint) && endPoint != null) {
                return;
            }
            if (!Objects.equals((Object)rule.getService(), null) && !Objects.equals((Object)rule.getService(), (Object)service) && service != null) {
                return;
            }
            if (!Objects.equals((Object)rule.getOperation(), null) && !Objects.equals((Object)rule.getOperation(), (Object)operation) && operation != null) {
                return;
            }
            if (endPoint != null && Objects.equals(rule.getEndPoint(), endPoint)) {
                ++score;
            }
            if (operation != null && Objects.equals((Object)rule.getOperation(), (Object)operation)) {
                ++score;
            }
            if (service != null && Objects.equals((Object)rule.getService(), (Object)service)) {
                ++score;
            }
            ruleMap.put(rule, score);
        });
        AtomicReference<Integer> biggestScore = new AtomicReference<Integer>(0);
        AtomicReference mostSpecific = new AtomicReference();
        ruleMap.entrySet().stream().forEach(entry -> {
            if ((Integer)entry.getValue() > (Integer)biggestScore.get()) {
                mostSpecific.set(entry.getKey());
                biggestScore.set((Integer)entry.getValue());
            }
        });
        if (interceptorRules.size() == 0) {
            LOG.error("Got no interceptor rules for this request/response. Usually this should not happen as one has to define at least the basic sets of rules (e.g. ALLOW all WMS requests) when using the interceptor.");
            throw new InterceptorException("No interceptor rule found.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Identified the following rule as most the specific one: " + mostSpecific.get());
        }
        return (InterceptorRule)mostSpecific.get();
    }

    private static List<NameValuePair> createQueryParams(Map<String, String[]> params) {
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String[]> param : params.entrySet()) {
            queryParams.add((NameValuePair)new BasicNameValuePair(param.getKey(), StringUtils.join((Object[])param.getValue(), (String)",")));
        }
        return queryParams;
    }

    private static URI getFullRequestURI(URI baseUri, List<NameValuePair> queryParams) throws URISyntaxException {
        URI requestUri = null;
        URIBuilder builder = new URIBuilder(baseUri);
        builder.addParameters(queryParams);
        requestUri = builder.build();
        return requestUri;
    }

    public URI getGeoServerBaseURIFromNameSpace(String geoServerNamespace, boolean useWmsReflector, boolean isWMS) throws URISyntaxException, InterceptorException {
        Object builder;
        URI uri = null;
        String geoServerUrl = this.geoServerNameSpaces.getProperty(geoServerNamespace);
        if (StringUtils.isEmpty((CharSequence)geoServerUrl)) {
            throw new InterceptorException("Couldn't detect GeoServer URI from the given namespace");
        }
        if (useWmsReflector && isWMS) {
            LOG.trace("Will use WMS reflector endpoint");
            if (StringUtils.endsWithIgnoreCase((CharSequence)geoServerUrl, (CharSequence)"ows")) {
                builder = new StringBuilder();
                int start = geoServerUrl.lastIndexOf("ows");
                ((StringBuilder)builder).append(geoServerUrl.substring(0, start));
                ((StringBuilder)builder).append("wms/reflect");
                geoServerUrl = ((StringBuilder)builder).toString();
            } else if (StringUtils.endsWithIgnoreCase((CharSequence)geoServerUrl, (CharSequence)"wms")) {
                geoServerUrl = geoServerUrl + "/reflect";
            }
            LOG.trace("The modified endpoint is: " + geoServerUrl);
        }
        builder = new URIBuilder(geoServerUrl);
        uri = builder.build();
        return uri;
    }

    private URI getGeoServerBaseURI(OgcMessage message, boolean useWmsReflector) throws URISyntaxException, InterceptorException {
        LOG.debug("Finding the GeoServer base URI by the provided EndPoint: " + message.getEndPoint());
        String geoServerNamespace = GeoServerInterceptorService.getGeoServerNameSpace(message.getEndPoint());
        LOG.trace("Found the following GeoServer namespace set in the EndPoint: " + geoServerNamespace);
        URI geoServerBaseUri = this.getGeoServerBaseURIFromNameSpace(geoServerNamespace, useWmsReflector, message.isWms());
        LOG.debug("The corresponding GeoServer base URI is: " + geoServerBaseUri);
        return geoServerBaseUri;
    }

    private static String getGeoServerNameSpace(String endPoint) {
        String geoServerNamespace = endPoint;
        if (endPoint.contains(":")) {
            String[] split = endPoint.split(":");
            geoServerNamespace = split[0];
        }
        return geoServerNamespace;
    }

    public static Response sendRequest(MutableHttpServletRequest request) throws InterceptorException, HttpException {
        Response httpResponse;
        block8: {
            httpResponse = new Response();
            String requestMethod = request.getMethod();
            boolean getRequest = "GET".equalsIgnoreCase(requestMethod);
            boolean postRequest = "POST".equalsIgnoreCase(requestMethod);
            try {
                URI requestUri = new URI(request.getRequestURI());
                Header[] requestHeaders = GeoServerInterceptorService.getRequestHeadersToForward(request);
                List<NameValuePair> allQueryParams = GeoServerInterceptorService.createQueryParams(request.getParameterMap());
                URI fullRequestUri = GeoServerInterceptorService.getFullRequestURI(requestUri, allQueryParams);
                if (getRequest) {
                    httpResponse = HttpUtil.get(fullRequestUri, requestHeaders);
                    break block8;
                }
                if (postRequest) {
                    String body;
                    String queryString = request.getQueryString();
                    if (queryString != null) {
                        requestUri = GeoServerInterceptorService.appendQueryString(requestUri, queryString);
                    }
                    if (!StringUtils.isEmpty((CharSequence)(body = OgcXmlUtil.getRequestBody((HttpServletRequest)request)))) {
                        ContentType contentType = ContentType.parse((String)request.getContentType());
                        if (contentType.getCharset() == null) {
                            contentType = contentType.withCharset("UTF-8");
                        }
                        httpResponse = HttpUtil.post(requestUri, body, contentType, requestHeaders);
                    } else {
                        httpResponse = HttpUtil.post(requestUri, allQueryParams, requestHeaders);
                    }
                    break block8;
                }
                throw new InterceptorException("Only GET or POST method is allowed");
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                LOG.error("Error while sending request: " + e.getMessage());
            }
        }
        return httpResponse;
    }

    private static Header[] getRequestHeadersToForward(MutableHttpServletRequest request) {
        ArrayList<BasicHeader> requestHeaderList = new ArrayList<BasicHeader>();
        for (String headerName : FORWARD_REQUEST_HEADER_KEYS) {
            String headerValue = request.getHeader(headerName);
            if (headerValue == null) continue;
            requestHeaderList.add(new BasicHeader(headerName, headerValue));
        }
        return requestHeaderList.toArray(new Header[0]);
    }

    public static URI appendQueryString(URI uri, String appendQuery) {
        if (uri == null || appendQuery == null || appendQuery.isEmpty()) {
            return uri;
        }
        String newQuery = uri.getQuery();
        newQuery = newQuery == null ? appendQuery : newQuery + "&" + appendQuery;
        URI newUri = uri;
        try {
            newUri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), newQuery, uri.getFragment());
        }
        catch (URISyntaxException e) {
            String msg = String.format("Failed to append query '%s' to URI '%s', returning URI unchanged.", appendQuery, uri);
            LOG.warn(msg);
        }
        return newUri;
    }

    private static HttpHeaders getResponseHeadersToForward(HttpHeaders headers) throws UnsupportedEncodingException {
        HttpHeaders responseHeaders = new HttpHeaders();
        if (headers == null) {
            LOG.debug("No headers found to forward!");
            return responseHeaders;
        }
        LOG.trace("Requested to filter the Headers to respond with:");
        for (Map.Entry header : headers.entrySet()) {
            String headerKey = (String)header.getKey();
            String headerVal = StringUtils.join((Iterable)((Iterable)header.getValue()), (String)",");
            LOG.trace("  * Header: " + headerKey);
            if (Arrays.asList(FORWARD_RESPONSE_HEADER_KEYS).contains(headerKey)) {
                Pattern pattern = Pattern.compile("subtype=(.*)");
                Matcher matcher = pattern.matcher(headerVal);
                if (matcher.find()) {
                    String replaceCandidate = matcher.group(1);
                    String replacer = StringUtils.prependIfMissing((String)replaceCandidate, (CharSequence)"\"", (CharSequence[])new CharSequence[0]);
                    replacer = StringUtils.appendIfMissing((String)replacer, (CharSequence)"\"", (CharSequence[])new CharSequence[0]);
                    headerVal = StringUtils.replace((String)headerVal, (String)replaceCandidate, (String)replacer);
                }
                responseHeaders.set(headerKey, headerVal);
                LOG.trace("    > Forwarded");
                continue;
            }
            LOG.trace("    > Skipped");
        }
        return responseHeaders;
    }

    public void setOgcMessageDistributor(OgcMessageDistributor ogcMessageDistributor) {
        this.ogcMessageDistributor = ogcMessageDistributor;
    }

    public void setInterceptorRuleService(InterceptorRuleService<InterceptorRule, ?> interceptorRuleService) {
        this.interceptorRuleService = interceptorRuleService;
    }

    public Properties getGeoServerNameSpaces() {
        return this.geoServerNameSpaces;
    }

    @Autowired
    @Qualifier(value="geoServerNameSpaces")
    public void setGeoServerNameSpaces(Properties geoServerNameSpaces) {
        this.geoServerNameSpaces = geoServerNameSpaces;
    }
}

