/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.UserGroupDao;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.service.PermissionAwareCrudService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userGroupService")
public class UserGroupService<E extends UserGroup, D extends UserGroupDao<E>>
extends PermissionAwareCrudService<E, D> {
    public UserGroupService() {
        this(UserGroup.class);
    }

    protected UserGroupService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="userGroupDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    @PostFilter(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(filterObject, 'READ')")
    @Transactional(readOnly=true)
    public Set<User> getUsersOfGroup(Integer groupId) throws Exception {
        HashSet<User> groupUsersSet = new HashSet();
        UserGroup userGroup = (UserGroup)this.findById(groupId);
        if (userGroup == null) {
            throw new Exception("The group with id " + groupId + " could not be found");
        }
        this.LOG.trace("Found group with ID " + userGroup.getId());
        groupUsersSet = userGroup.getMembers();
        return groupUsersSet;
    }
}

