/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class EntityUtil {
    public static final String RESTRICT_FIELDS_PARAM = "output:only";

    public static boolean isField(Class<?> clazz, String fieldName, Class<?> fieldEntityType, boolean forceAccess) {
        Field field = FieldUtils.getField(clazz, (String)fieldName, (boolean)forceAccess);
        if (field == null) {
            return false;
        }
        Class<?> fieldType = field.getType();
        return fieldEntityType == null || fieldType.isAssignableFrom(fieldEntityType);
    }

    public static boolean isCollectionField(Class<?> clazz, String fieldName, Class<?> collectionElementType, boolean forceAccess) {
        Field field = FieldUtils.getField(clazz, (String)fieldName, (boolean)forceAccess);
        if (field == null) {
            return false;
        }
        boolean isCollectionField = false;
        if (Collection.class.isAssignableFrom(field.getType())) {
            ParameterizedType collType = (ParameterizedType)field.getGenericType();
            Class elementTypeOfCollection = (Class)collType.getActualTypeArguments()[0];
            isCollectionField = elementTypeOfCollection.isAssignableFrom(collectionElementType);
        }
        return isCollectionField;
    }

    public static List<String> getFilterableOrRestrictableFieldNames(Class<?> entityClass) {
        List allFields = FieldUtils.getAllFieldsList(entityClass);
        ArrayList<String> restrictableFields = new ArrayList<String>();
        for (Field field : allFields) {
            Class<?> fieldType = field.getType();
            String fieldName = field.getName();
            int fieldModifiers = field.getModifiers();
            boolean isPrimitiveOrWrapper = ClassUtils.isPrimitiveOrWrapper(fieldType);
            boolean isString = fieldType.equals(String.class);
            boolean isStatic = Modifier.isStatic(fieldModifiers);
            boolean isPrivate = Modifier.isPrivate(fieldModifiers);
            if (!isPrimitiveOrWrapper && !isString || !isPrivate || isStatic) continue;
            restrictableFields.add(fieldName);
        }
        return restrictableFields;
    }

    public static List<String> listFromCommaSeparatedStringList(List<String> listOfCommaSeparatedValues) {
        if (listOfCommaSeparatedValues == null) {
            return null;
        }
        ArrayList<String> outList = new ArrayList<String>();
        for (String commaSeparatedValues : listOfCommaSeparatedValues) {
            if (commaSeparatedValues == null) continue;
            List<String> values = Arrays.asList(commaSeparatedValues.split("\\s*,\\s*"));
            outList.addAll(values);
        }
        if (outList.size() == 0) {
            return null;
        }
        return outList;
    }

    public static List<String> determineRestrictFields(MultiValueMap<String, String> requestedFilter, Class<?> entityClass) {
        if (requestedFilter == null) {
            return null;
        }
        List<String> restrictFieldsTo = null;
        Set keys = requestedFilter.keySet();
        for (String key : keys) {
            if (!RESTRICT_FIELDS_PARAM.equalsIgnoreCase(key)) continue;
            restrictFieldsTo = EntityUtil.listFromCommaSeparatedStringList((List)requestedFilter.get((Object)key));
        }
        if (restrictFieldsTo == null) {
            return null;
        }
        List<String> restrictableFieldNames = EntityUtil.getFilterableOrRestrictableFieldNames(entityClass);
        ArrayList<String> filteredRestrictTo = new ArrayList<String>();
        for (String restrictableFieldName : restrictableFieldNames) {
            for (String requestedRestrictTo : restrictFieldsTo) {
                if (!restrictableFieldName.equalsIgnoreCase(requestedRestrictTo)) continue;
                filteredRestrictTo.add(restrictableFieldName);
            }
        }
        if (filteredRestrictTo.size() == 0) {
            filteredRestrictTo = null;
        }
        return filteredRestrictTo;
    }

    public static MultiValueMap<String, Object> validFieldNamesWithCastedValues(MultiValueMap<String, String> requestedFilter, Class<?> entityClass) {
        Set inputFieldNames = requestedFilter.keySet();
        HashMap<String, String> validInputFieldNameToOrigFieldName = new HashMap<String, String>();
        List<String> filterableFieldNames = EntityUtil.getFilterableOrRestrictableFieldNames(entityClass);
        block0: for (String filterableFieldName : filterableFieldNames) {
            for (String inputFieldName : inputFieldNames) {
                if (!filterableFieldName.equalsIgnoreCase(inputFieldName)) continue;
                validInputFieldNameToOrigFieldName.put(inputFieldName, filterableFieldName);
                continue block0;
            }
        }
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        Set validInputFieldNames = validInputFieldNameToOrigFieldName.keySet();
        for (String validInputFieldName : validInputFieldNames) {
            String origInputFieldName = (String)validInputFieldNameToOrigFieldName.get(validInputFieldName);
            List stringValues = (List)requestedFilter.get((Object)validInputFieldName);
            for (String fieldStringValue : stringValues) {
                Field f = FieldUtils.getField(entityClass, (String)origInputFieldName, (boolean)true);
                Class<?> fieldType = f.getType();
                Object castedValue = ConvertUtils.convert((String)fieldStringValue, fieldType);
                result.add((Object)origInputFieldName, castedValue);
            }
        }
        return result;
    }
}

