/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor;

import de.terrestris.shoguncore.util.interceptor.InterceptorException;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.OgcMessage;
import de.terrestris.shoguncore.util.interceptor.WcsRequestInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.WcsResponseInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.WfsRequestInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.WfsResponseInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.WmsRequestInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.WmsResponseInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.WpsRequestInterceptorInterface;
import de.terrestris.shoguncore.util.interceptor.WpsResponseInterceptorInterface;
import de.terrestris.shoguncore.util.model.Response;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class OgcMessageDistributor {
    private static final Logger LOG = LogManager.getLogger(OgcMessageDistributor.class);
    private static final String MODIFYING_REQUEST_MSG = "Modifying a {0} {1} request";
    private static final String MODIFYING_RESPONSE_MSG = "Modifying a {0} {1} response";
    private static final String REQUEST_IMPLEMENTATION_NOT_FOUND_MSG = "No interceptor class implementation for request {0} {1} found. Forwarding the original request.";
    private static final String RESPONSE_IMPLEMENTATION_NOT_FOUND_MSG = "No interceptor class implementation for response {0} {1} found. Returning the original response.";
    private static final String REQUEST_NOT_SUPPORTED_MSG = "The request type {0} is not supported";
    private static final String RESPONSE_NOT_SUPPORTED_MSG = "The response type {0} is not supported";
    @Autowired(required=false)
    @Qualifier(value="wmsRequestInterceptor")
    private WmsRequestInterceptorInterface wmsRequestInterceptor;
    @Autowired(required=false)
    @Qualifier(value="wfsRequestInterceptor")
    private WfsRequestInterceptorInterface wfsRequestInterceptor;
    @Autowired(required=false)
    @Qualifier(value="wcsRequestInterceptor")
    private WcsRequestInterceptorInterface wcsRequestInterceptor;
    @Autowired(required=false)
    @Qualifier(value="wpsRequestInterceptor")
    private WpsRequestInterceptorInterface wpsRequestInterceptor;
    @Autowired(required=false)
    @Qualifier(value="wmsResponseInterceptor")
    private WmsResponseInterceptorInterface wmsResponseInterceptor;
    @Autowired(required=false)
    @Qualifier(value="wfsResponseInterceptor")
    private WfsResponseInterceptorInterface wfsResponseInterceptor;
    @Autowired(required=false)
    @Qualifier(value="wcsResponseInterceptor")
    private WcsResponseInterceptorInterface wcsResponseInterceptor;
    @Autowired(required=false)
    @Qualifier(value="wpsResponseInterceptor")
    private WpsResponseInterceptorInterface wpsResponseInterceptor;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MutableHttpServletRequest distributeToRequestInterceptor(MutableHttpServletRequest request, OgcMessage message) throws InterceptorException {
        if (message.isRequestAllowed()) {
            LOG.debug("Request is ALLOWED, not intercepting the request.");
            return request;
        }
        if (message.isRequestDenied()) {
            throw new InterceptorException("Request is DENIED, blocking the request.");
        }
        if (message.isRequestModified()) {
            LOG.debug("Request is to be MODIFIED, intercepting the request.");
        }
        String implErrMsg = MessageFormat.format(REQUEST_IMPLEMENTATION_NOT_FOUND_MSG, new Object[]{message.getService(), message.getOperation()});
        String infoMsg = MessageFormat.format(MODIFYING_REQUEST_MSG, new Object[]{message.getService(), message.getOperation()});
        String serviceErrMsg = MessageFormat.format(REQUEST_NOT_SUPPORTED_MSG, new Object[]{message.getService()});
        String operationErrMsg = MessageFormat.format(REQUEST_NOT_SUPPORTED_MSG, new Object[]{message.getOperation()});
        if (message.isWms()) {
            if (this.wmsRequestInterceptor == null) {
                LOG.debug(implErrMsg);
                return request;
            }
            LOG.debug(infoMsg);
            if (message.isWmsGetCapabilities()) {
                request = this.wmsRequestInterceptor.interceptGetCapabilities(request);
            } else if (message.isWmsGetMap()) {
                request = this.wmsRequestInterceptor.interceptGetMap(request);
            } else if (message.isWmsGetFeatureInfo()) {
                request = this.wmsRequestInterceptor.interceptGetFeatureInfo(request);
            } else if (message.isWmsGetLegendGraphic()) {
                request = this.wmsRequestInterceptor.interceptGetLegendGraphic(request);
            } else if (message.isWmsGetStyles()) {
                request = this.wmsRequestInterceptor.interceptGetStyles(request);
            } else {
                if (!message.isWmsDescribeLayer()) throw new InterceptorException(operationErrMsg);
                request = this.wmsRequestInterceptor.interceptDescribeLayer(request);
            }
        } else if (message.isWfs()) {
            if (this.wfsRequestInterceptor == null) {
                LOG.debug(implErrMsg);
                return request;
            }
            LOG.debug(infoMsg);
            if (message.isWfsGetCapabilities()) {
                request = this.wfsRequestInterceptor.interceptGetCapabilities(request);
            } else if (message.isWfsGetFeature()) {
                request = this.wfsRequestInterceptor.interceptGetFeature(request);
            } else if (message.isWfsDescribeFeatureType()) {
                request = this.wfsRequestInterceptor.interceptDescribeFeatureType(request);
            } else if (message.isWfsTransaction()) {
                request = this.wfsRequestInterceptor.interceptTransaction(request);
            } else {
                if (!message.isWfsLockFeature()) throw new InterceptorException(operationErrMsg);
                request = this.wfsRequestInterceptor.interceptLockFeature(request);
            }
        } else if (message.isWcs()) {
            if (this.wcsRequestInterceptor == null) {
                LOG.debug(implErrMsg);
                return request;
            }
            LOG.debug(infoMsg);
            if (message.isWcsGetCapabilities()) {
                request = this.wcsRequestInterceptor.interceptGetCapabilities(request);
            } else if (message.isWcsDescribeCoverage()) {
                request = this.wcsRequestInterceptor.interceptDescribeCoverage(request);
            } else {
                if (!message.isWcsGetCoverage()) throw new InterceptorException(operationErrMsg);
                request = this.wcsRequestInterceptor.interceptGetCoverage(request);
            }
        } else {
            if (!message.isWps()) throw new InterceptorException(serviceErrMsg);
            if (this.wpsRequestInterceptor == null) {
                LOG.debug(implErrMsg);
                return request;
            }
            if (message.isWpsGetCapabilities()) {
                return this.wpsRequestInterceptor.interceptGetCapabilities(request);
            }
            if (message.isWpsDescribeProcess()) {
                return this.wpsRequestInterceptor.interceptDescribeProcess(request);
            }
            if (!message.isWpsExecute()) throw new InterceptorException(operationErrMsg);
            return this.wpsRequestInterceptor.interceptExecute(request);
        }
        if (request != null) return request;
        throw new InterceptorException("The request object is null. Please check your RequestInterceptor implementation.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response distributeToResponseInterceptor(MutableHttpServletRequest mutableRequest, Response response, OgcMessage message) throws InterceptorException {
        if (message.isResponseAllowed()) {
            LOG.debug("Response is ALLOWED, not intercepting the response.");
            return response;
        }
        if (message.isResponseDenied()) {
            throw new InterceptorException("Response is DENIED, blocking the response.");
        }
        if (message.isResponseModified()) {
            LOG.debug("Response is to be MODIFIED, intercepting the response.");
        }
        String implErrMsg = MessageFormat.format(RESPONSE_IMPLEMENTATION_NOT_FOUND_MSG, new Object[]{message.getService(), message.getOperation()});
        String infoMsg = MessageFormat.format(MODIFYING_RESPONSE_MSG, new Object[]{message.getService(), message.getOperation()});
        String serviceErrMsg = MessageFormat.format(RESPONSE_NOT_SUPPORTED_MSG, new Object[]{message.getService()});
        String operationErrMsg = MessageFormat.format(RESPONSE_NOT_SUPPORTED_MSG, new Object[]{message.getOperation()});
        if (message.isWms()) {
            if (this.wmsResponseInterceptor == null) {
                LOG.debug(implErrMsg);
                return response;
            }
            LOG.debug(infoMsg);
            if (message.isWmsGetCapabilities()) {
                response = this.wmsResponseInterceptor.interceptGetCapabilities(mutableRequest, response);
            } else if (message.isWmsGetMap()) {
                response = this.wmsResponseInterceptor.interceptGetMap(mutableRequest, response);
            } else if (message.isWmsGetFeatureInfo()) {
                response = this.wmsResponseInterceptor.interceptGetFeatureInfo(mutableRequest, response);
            } else if (message.isWmsGetLegendGraphic()) {
                response = this.wmsResponseInterceptor.interceptGetLegendGraphic(mutableRequest, response);
            } else if (message.isWmsGetStyles()) {
                response = this.wmsResponseInterceptor.interceptGetStyles(mutableRequest, response);
            } else {
                if (!message.isWmsDescribeLayer()) throw new InterceptorException(operationErrMsg);
                response = this.wmsResponseInterceptor.interceptDescribeLayer(mutableRequest, response);
            }
        } else if (message.isWfs()) {
            if (this.wfsResponseInterceptor == null) {
                LOG.debug(implErrMsg);
                return response;
            }
            LOG.debug(infoMsg);
            if (message.isWfsGetCapabilities()) {
                response = this.wfsResponseInterceptor.interceptGetCapabilities(mutableRequest, response);
            } else if (message.isWfsGetFeature()) {
                response = this.wfsResponseInterceptor.interceptGetFeature(mutableRequest, response);
            } else if (message.isWfsDescribeFeatureType()) {
                response = this.wfsResponseInterceptor.interceptDescribeFeatureType(mutableRequest, response);
            } else if (message.isWfsTransaction()) {
                response = this.wfsResponseInterceptor.interceptTransaction(mutableRequest, response);
            } else {
                if (!message.isWfsLockFeature()) throw new InterceptorException(operationErrMsg);
                response = this.wfsResponseInterceptor.interceptLockFeature(mutableRequest, response);
            }
        } else if (message.isWcs()) {
            if (this.wcsResponseInterceptor == null) {
                LOG.debug(implErrMsg);
                return response;
            }
            LOG.debug(infoMsg);
            if (message.isWcsGetCapabilities()) {
                response = this.wcsResponseInterceptor.interceptGetCapabilities(mutableRequest, response);
            } else if (message.isWcsDescribeCoverage()) {
                response = this.wcsResponseInterceptor.interceptDescribeCoverage(mutableRequest, response);
            } else {
                if (!message.isWcsGetCoverage()) throw new InterceptorException(operationErrMsg);
                response = this.wcsResponseInterceptor.interceptGetCoverage(mutableRequest, response);
            }
        } else {
            if (!message.isWps()) throw new InterceptorException(serviceErrMsg);
            if (this.wpsResponseInterceptor == null) {
                LOG.debug(implErrMsg);
                return response;
            }
            LOG.debug(infoMsg);
            if (message.isWpsGetCapabilities()) {
                response = this.wpsResponseInterceptor.interceptGetCapabilities(mutableRequest, response);
            } else if (message.isWpsDescribeProcess()) {
                response = this.wpsResponseInterceptor.interceptDescribeProcess(mutableRequest, response);
            } else {
                if (!message.isWpsExecute()) throw new InterceptorException(operationErrMsg);
                response = this.wpsResponseInterceptor.interceptExecute(mutableRequest, response);
            }
        }
        if (response != null) return response;
        throw new InterceptorException("The response object is null. Please check your ResponseInterceptor implementation.");
    }

    public void setWmsRequestInterceptor(WmsRequestInterceptorInterface wmsRequestInterceptor) {
        this.wmsRequestInterceptor = wmsRequestInterceptor;
    }

    public void setWfsRequestInterceptor(WfsRequestInterceptorInterface wfsRequestInterceptor) {
        this.wfsRequestInterceptor = wfsRequestInterceptor;
    }

    public void setWcsRequestInterceptor(WcsRequestInterceptorInterface wcsRequestInterceptor) {
        this.wcsRequestInterceptor = wcsRequestInterceptor;
    }

    public WpsRequestInterceptorInterface getWpsRequestInterceptor() {
        return this.wpsRequestInterceptor;
    }

    public void setWpsRequestInterceptor(WpsRequestInterceptorInterface wpsRequestInterceptor) {
        this.wpsRequestInterceptor = wpsRequestInterceptor;
    }

    public void setWmsResponseInterceptor(WmsResponseInterceptorInterface wmsResponseInterceptor) {
        this.wmsResponseInterceptor = wmsResponseInterceptor;
    }

    public void setWfsResponseInterceptor(WfsResponseInterceptorInterface wfsResponseInterceptor) {
        this.wfsResponseInterceptor = wfsResponseInterceptor;
    }

    public void setWcsResponseInterceptor(WcsResponseInterceptorInterface wcsResponseInterceptor) {
        this.wcsResponseInterceptor = wcsResponseInterceptor;
    }

    public WpsResponseInterceptorInterface getWpsResponseInterceptor() {
        return this.wpsResponseInterceptor;
    }

    public void setWpsResponseInterceptor(WpsResponseInterceptorInterface wpsResponseInterceptor) {
        this.wpsResponseInterceptor = wpsResponseInterceptor;
    }
}

