/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.impl;

import de.terrestris.shoguncore.util.interceptor.BasicAuthHeaderRequest;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WfsRequestInterceptorInterface;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

public class WfsRequestInterceptor
implements WfsRequestInterceptorInterface {
    private static final Logger LOG = LogManager.getLogger(WfsRequestInterceptor.class);
    @Value(value="${geoserver.username:}")
    private String gsUser;
    @Value(value="${geoserver.password:}")
    private String gsPass;

    @Override
    public MutableHttpServletRequest interceptGetCapabilities(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS GetCapabilities and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptDescribeFeatureType(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS DescribeFeatureType and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptGetFeature(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS GetFeature and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptLockFeature(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS LockFeature and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptTransaction(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WFS Transaction and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }
}

