/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.web;

import de.terrestris.shoguncore.dao.FileDao;
import de.terrestris.shoguncore.model.File;
import de.terrestris.shoguncore.service.FileService;
import de.terrestris.shoguncore.util.data.ResultSet;
import de.terrestris.shoguncore.web.AbstractWebController;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/file"})
public class FileController<E extends File, D extends FileDao<E>, S extends FileService<E, D>>
extends AbstractWebController<E, D, S> {
    public FileController() {
        this(File.class);
    }

    protected FileController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="fileService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"/upload.action"}, method={RequestMethod.POST})
    public ResponseEntity<?> uploadFile(@RequestParam(value="file") MultipartFile uploadedFile) {
        this.LOG.debug("Requested to upload a multipart-file");
        Map<Object, Object> responseMap = new HashMap();
        try {
            Object file = ((FileService)this.service).uploadFile(uploadedFile);
            this.LOG.info("Successfully uploaded file " + ((File)file).getFileName());
            responseMap = ResultSet.success(file);
        }
        catch (Exception e) {
            this.LOG.error("Could not upload the file: " + e.getMessage());
            responseMap = ResultSet.error("Could not upload the file: " + e.getMessage());
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return new ResponseEntity(responseMap, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/get.action"}, method={RequestMethod.GET})
    public ResponseEntity<?> getFile(@RequestParam Integer id) {
        HttpHeaders responseHeaders = new HttpHeaders();
        Map<Object, Object> responseMap = new HashMap();
        try {
            File file = (File)((FileService)this.service).findById(id);
            if (file == null) {
                throw new Exception("Could not find the file with id " + id);
            }
            byte[] fileBytes = file.getFile();
            responseHeaders.setContentType(MediaType.parseMediaType((String)file.getFileType()));
            this.LOG.info("Successfully got the file " + file.getFileName());
            responseMap = ResultSet.success(file);
            return new ResponseEntity((Object)fileBytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOG.error("Could not get the file: " + e.getMessage());
            responseMap = ResultSet.error("Could not get the file: " + e.getMessage());
            responseHeaders.setContentType(MediaType.APPLICATION_JSON);
            return new ResponseEntity(responseMap, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
    }
}

