/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.terrestris.shoguncore.dao.GenericHibernateDao;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.service.AbstractDaoService;
import de.terrestris.shoguncore.util.entity.EntityUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;

public abstract class AbstractCrudService<E extends PersistentObject, D extends GenericHibernateDao<E, Integer>>
extends AbstractDaoService<E, D> {
    protected AbstractCrudService(Class<E> entityClass) {
        super(entityClass);
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or (#e.id == null and hasPermission(#e, 'CREATE')) or (#e.id != null and hasPermission(#e, 'UPDATE'))")
    public void saveOrUpdate(E e) {
        this.dao.saveOrUpdate(e);
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#entity, 'UPDATE')")
    public E updatePartialWithJsonNode(E entity, JsonNode jsonObject, ObjectMapper objectMapper) throws IOException, JsonProcessingException {
        entity = (PersistentObject)objectMapper.readerForUpdating(entity).readValue(jsonObject);
        this.saveOrUpdate(entity);
        return entity;
    }

    @PostAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(returnObject, 'READ')")
    @Transactional(readOnly=true)
    public E findById(Integer id) {
        return this.dao.findById(id);
    }

    @PostAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(returnObject, 'READ')")
    @Transactional(readOnly=true)
    public E loadById(int id) {
        return this.dao.loadById(id);
    }

    @PostFilter(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(filterObject, 'READ')")
    @Transactional(readOnly=true)
    public List<E> findAll() {
        return this.dao.findAll();
    }

    @PostFilter(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(filterObject, 'READ')")
    public List<E> findAllRestricted(MultiValueMap<String, String> restrictToRequest) {
        List<String> restrictFields = EntityUtil.determineRestrictFields(restrictToRequest, this.getEntityClass());
        return this.dao.findByCriteriaRestricted(restrictFields, new Criterion[0]);
    }

    @PostFilter(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(filterObject, 'READ')")
    @Transactional(readOnly=true)
    public List<E> findBySimpleFilter(MultiValueMap<String, String> requestedFilter) {
        List<String> restrictFields = EntityUtil.determineRestrictFields(requestedFilter, this.getEntityClass());
        requestedFilter.remove((Object)"output:only");
        MultiValueMap<String, Object> origFieldNamesToCastedValues = EntityUtil.validFieldNamesWithCastedValues(requestedFilter, this.getEntityClass());
        List results = new ArrayList();
        ArrayList<Disjunction> orPredicates = new ArrayList<Disjunction>();
        if (origFieldNamesToCastedValues != null && !origFieldNamesToCastedValues.isEmpty()) {
            for (String fieldName : origFieldNamesToCastedValues.keySet()) {
                List fieldValues = (List)origFieldNamesToCastedValues.get((Object)fieldName);
                ArrayList<SimpleExpression> eqExpressions = new ArrayList<SimpleExpression>();
                for (Object fieldValue : fieldValues) {
                    SimpleExpression eq = Restrictions.eq((String)fieldName, fieldValue);
                    eqExpressions.add(eq);
                }
                if (eqExpressions.isEmpty()) continue;
                Criterion[] eqArray = eqExpressions.toArray(new Criterion[0]);
                Disjunction or = Restrictions.or((Criterion[])eqArray);
                orPredicates.add(or);
            }
            if (!orPredicates.isEmpty()) {
                Criterion[] orArray = orPredicates.toArray(new Criterion[0]);
                Conjunction and = Restrictions.and((Criterion[])orArray);
                results = this.dao.findByCriteriaRestricted(restrictFields, new Criterion[]{and});
            }
        }
        return results;
    }

    @PostFilter(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(filterObject, 'READ')")
    @Transactional(readOnly=true)
    public List<E> findAllWhereFieldEquals(String fieldName, Object fieldValue) {
        return this.dao.findAllWhereFieldEquals(fieldName, fieldValue, new Criterion[0]);
    }

    @PostFilter(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(filterObject, 'READ')")
    @Transactional(readOnly=true)
    public List<E> findAllWithCollectionContaining(String fieldName, PersistentObject subElement) {
        return this.dao.findAllWithCollectionContaining(fieldName, subElement, new Criterion[0]);
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#e, 'DELETE')")
    public void delete(E e) {
        this.dao.delete(e);
    }
}

