/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.impl;

import de.terrestris.shoguncore.util.interceptor.BasicAuthHeaderRequest;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WmsRequestInterceptorInterface;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

public class WmsRequestInterceptor
implements WmsRequestInterceptorInterface {
    private static final Logger LOG = LogManager.getLogger(WmsRequestInterceptor.class);
    @Value(value="${geoserver.username:}")
    private String gsUser;
    @Value(value="${geoserver.password:}")
    private String gsPass;

    @Override
    public MutableHttpServletRequest interceptGetMap(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetMap and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptGetFeatureInfo(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetFeatureInfo and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptDescribeLayer(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS DescribeLayer and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptGetLegendGraphic(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetLegendGraphic and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptGetStyles(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetStyles and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptGetCapabilities(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WMS GetCapabilities and adding Basic auth credentials.");
        return new BasicAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }
}

