/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.web;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import de.terrestris.shoguncore.service.ModelDescriptionService;
import de.terrestris.shoguncore.util.data.ResultSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/describeModel"})
public class ModelDescriptionController {
    @Autowired
    @Qualifier(value="modelDescriptionService")
    private ModelDescriptionService modelDescriptionService;

    @RequestMapping(value={"/asJson/{className}.action"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getJsonSchema(@PathVariable String className) {
        try {
            JsonSchema json = this.modelDescriptionService.getJsonSchema(className);
            if (json == null) {
                return ResultSet.error("Model description (json) for model " + className + " is null.");
            }
            return ResultSet.success(json);
        }
        catch (Exception e) {
            return ResultSet.error("Could not get description for " + className + " " + e.getMessage());
        }
    }

    public void setModelDescriptionService(ModelDescriptionService modelDescriptionService) {
        this.modelDescriptionService = modelDescriptionService;
    }
}

