/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.converter;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.annotation.SimpleObjectIdResolver;
import de.terrestris.shoguncore.dao.GenericHibernateDao;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.service.AbstractCrudService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public abstract class PersistentObjectIdResolver<E extends PersistentObject, D extends GenericHibernateDao<E, Integer>, S extends AbstractCrudService<E, D>>
extends SimpleObjectIdResolver {
    protected final Logger LOG = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected S service;

    protected PersistentObjectIdResolver() {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)((Object)this));
    }

    public abstract void setService(S var1);

    public void bindItem(ObjectIdGenerator.IdKey id, Object ob) {
        super.bindItem(id, ob);
    }

    public E resolveId(ObjectIdGenerator.IdKey idKey) {
        try {
            if (idKey.key instanceof Integer) {
                Integer id = (Integer)idKey.key;
                return ((AbstractCrudService)this.service).loadById(id);
            }
            throw new Exception("ID is not of type Integer.");
        }
        catch (Exception e) {
            this.LOG.error("Could not resolve object by ID: " + e.getMessage());
            return null;
        }
    }

    public boolean canUseFor(ObjectIdResolver resolverType) {
        return super.canUseFor(resolverType);
    }

    public ObjectIdResolver newForDeserialization(Object context) {
        try {
            return (ObjectIdResolver)((Object)((Object)this)).getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.LOG.error("Error instantiating ObjectIdResolver: " + e.getMessage());
            return null;
        }
    }

    public S getService() {
        return this.service;
    }
}

