/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.module;

import de.terrestris.shoguncore.model.layout.Layout;
import de.terrestris.shoguncore.model.module.Module;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table
@Cacheable
public class CompositeModule
extends Module {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Layout layout;
    @ManyToMany
    @JoinTable(name="MODULES_SUBMODULES", joinColumns={@JoinColumn(name="MODULE_ID")}, inverseJoinColumns={@JoinColumn(name="SUBMODULE_ID")})
    @OrderColumn(name="IDX")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private List<Module> subModules = new ArrayList<Module>();

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void addModule(Module module) {
        this.subModules.add(module);
    }

    public void remove(Module module) {
        this.subModules.remove(module);
    }

    public List<Module> getSubModules() {
        return this.subModules;
    }

    public void setSubModules(List<Module> subModules) {
        this.subModules = subModules;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 19).appendSuper(super.hashCode()).append((Object)this.getLayout()).append(this.getSubModules()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeModule)) {
            return false;
        }
        CompositeModule other = (CompositeModule)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getLayout(), (Object)other.getLayout()).append(this.getSubModules(), other.getSubModules()).isEquals();
    }
}

