/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.terrestris.shoguncore.dao.GenericHibernateDao;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.service.AbstractCrudService;
import de.terrestris.shoguncore.web.AbstractWebController;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/rest"})
public abstract class AbstractRestController<E extends PersistentObject, D extends GenericHibernateDao<E, Integer>, S extends AbstractCrudService<E, D>>
extends AbstractWebController<E, D, S> {
    @Autowired
    protected ObjectMapper objectMapper;

    protected AbstractRestController(Class<E> entityClass) {
        super(entityClass);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<List<E>> findAll(@RequestParam MultiValueMap<String, String> requestParams) {
        List resultList = this.service.findAllRestricted(requestParams);
        if (resultList != null && !resultList.isEmpty()) {
            this.LOG.trace("Found a total of " + resultList.size() + " entities of type " + ((PersistentObject)resultList.get(0)).getClass().getSimpleName());
        }
        return new ResponseEntity(resultList, HttpStatus.OK);
    }

    @RequestMapping(value={"/filter"}, method={RequestMethod.GET})
    public ResponseEntity<List<E>> findBySimpleFilter(@RequestParam MultiValueMap<String, String> requestParams) {
        List resultList = this.service.findBySimpleFilter(requestParams);
        if (resultList != null && !resultList.isEmpty()) {
            this.LOG.trace("Found a total of " + resultList.size() + " entities of type " + ((PersistentObject)resultList.get(0)).getClass().getSimpleName());
        }
        return new ResponseEntity(resultList, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<E> findById(@PathVariable Integer id) {
        try {
            Object entity = this.service.findById(id);
            this.LOG.trace("Found " + entity.getClass().getSimpleName() + " with ID " + ((PersistentObject)entity).getId());
            return new ResponseEntity(entity, HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOG.error("Error finding entity with id " + id + ": " + e.getMessage());
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<E> save(HttpServletRequest request) {
        String simpleClassName = this.getEntityClass().getSimpleName();
        String errorMessagePrefix = "Error when saving entity of type " + simpleClassName + ": ";
        BufferedReader reader = null;
        try {
            reader = request.getReader();
            PersistentObject entity = (PersistentObject)this.objectMapper.readValue((Reader)reader, this.getEntityClass());
            Integer id = entity.getId();
            if (id != null) {
                this.LOG.error(errorMessagePrefix + "ID value is set to " + id + ", but MUST be null");
                ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            this.service.saveOrUpdate(entity);
            this.LOG.trace("Created " + simpleClassName + " with ID " + entity.getId());
            ResponseEntity responseEntity = new ResponseEntity((Object)entity, HttpStatus.CREATED);
            return responseEntity;
        }
        catch (Exception e) {
            this.LOG.error(errorMessagePrefix + e.getMessage());
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
            return responseEntity;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<E> update(@PathVariable int id, HttpServletRequest request) {
        String errorPrefix = "Error updating " + this.getEntityClass().getSimpleName() + " with ID " + id + ": ";
        BufferedReader reader = null;
        try {
            reader = request.getReader();
            JsonNode jsonObject = this.objectMapper.readTree((Reader)reader);
            if (jsonObject == null || !jsonObject.has("id")) {
                this.LOG.error(errorPrefix + "The JSON body is empty or has no 'id' property.");
                ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            int payloadId = jsonObject.get("id").asInt();
            if (payloadId != id) {
                this.LOG.error(errorPrefix + "Requested to update entity with ID " + id + ", but payload ID is " + payloadId);
                ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            Object entity = this.service.findById(id);
            if (entity != null) {
                entity = this.service.updatePartialWithJsonNode(entity, jsonObject, this.objectMapper);
                ResponseEntity responseEntity = new ResponseEntity(entity, HttpStatus.OK);
                return responseEntity;
            }
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (Exception e) {
            this.LOG.error(errorPrefix + e.getMessage());
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<E> delete(@PathVariable int id) {
        try {
            Object entityToDelete = this.service.findById(id);
            this.service.delete(entityToDelete);
            String proxyClassName = entityToDelete.getClass().getSimpleName();
            String simpleClassName = StringUtils.substringBefore((String)proxyClassName, (String)"_$$_");
            this.LOG.trace("Deleted " + simpleClassName + " with ID " + id);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            this.LOG.error("Error deleting entity with ID " + id + ": " + e.getMessage());
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}

