/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service(value="localeService")
public class Csv2ExtJsLocaleService {
    @Autowired
    private ResourceLoader resourceLoader;

    public Map<String, Object> getAllComponentsForLocale(String appId, String locale) throws Exception {
        TreeMap<String, Object> resultMap = new TreeMap<String, Object>();
        Resource csvResource = this.resourceLoader.getResource("classpath:META-INF/locale/" + appId + ".csv");
        if (!csvResource.exists()) {
            throw new Exception("CSV locale resource for " + appId + " does not exist.");
        }
        FileInputStream fileIs = new FileInputStream(csvResource.getFile().getCanonicalPath());
        InputStreamReader reader = new InputStreamReader((InputStream)fileIs, StandardCharsets.UTF_8);
        CSVParser csvParser = new CSVParserBuilder().withSeparator(';').withQuoteChar('\"').withEscapeChar('\\').build();
        CSVReader csvReader = new CSVReaderBuilder((Reader)reader).withCSVParser((ICSVParser)csvParser).build();
        try {
            int columnIndexOfLocale = this.detectColumnIndexOfLocale(locale, csvReader);
            boolean nextLineIsNotEmpty = true;
            while (nextLineIsNotEmpty) {
                String[] localeValue;
                String[] nextLineArray = ArrayUtils.nullToEmpty((String[])csvReader.readNext());
                List<String> nextLine = Arrays.asList(nextLineArray);
                nextLineIsNotEmpty = !nextLine.isEmpty();
                if (!nextLineIsNotEmpty) continue;
                String component = nextLine.get(0);
                String field = nextLine.get(1);
                String[] value = localeValue = nextLine.get(columnIndexOfLocale);
                if (component.isEmpty()) {
                    throw new Exception("Missing component entry in CSV line " + csvReader.getLinesRead());
                }
                if (field.isEmpty()) {
                    throw new Exception("Missing field entry in CSV line " + csvReader.getLinesRead());
                }
                Object componentEntry = resultMap.containsKey(component) ? resultMap.get(component) : new TreeMap();
                if (field.contains("[]")) {
                    if (Pattern.matches(".+(\\[])$", field) && StringUtils.countMatches((CharSequence)field, (CharSequence)"[]") == 1) {
                        field = field.replace("[]", "");
                        value = localeValue.isEmpty() ? ArrayUtils.EMPTY_STRING_ARRAY : localeValue.split(",");
                    } else {
                        throw new Exception("Invalid field description '" + field + "': '[]' may only occure once at the end, but not before");
                    }
                }
                StructureUtils.putValueIntoMapOfMaps((Map)((Map)componentEntry), (String)field, (Object)value);
                resultMap.put(component, componentEntry);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileIs);
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Closeable)csvReader);
        }
        return resultMap;
    }

    private int detectColumnIndexOfLocale(String locale, CSVReader csvReader) throws Exception {
        int indexOfLocale = -1;
        List<String> headerLine = Arrays.asList(ArrayUtils.nullToEmpty((String[])csvReader.readNext()));
        if (headerLine == null || headerLine.isEmpty()) {
            throw new Exception("CSV locale file seems to be empty.");
        }
        if (headerLine.size() < 3) {
            throw new Exception("CSV locale file is invalid: Not enough columns.");
        }
        for (int i = 2; i < headerLine.size(); ++i) {
            String columnName = headerLine.get(i);
            if (!locale.equalsIgnoreCase(columnName)) continue;
            indexOfLocale = headerLine.indexOf(columnName);
            break;
        }
        if (indexOfLocale < 0) {
            throw new Exception("Could not find locale " + locale + " in CSV file");
        }
        return indexOfLocale;
    }
}

