/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.ApplicationDao;
import de.terrestris.shoguncore.dao.PluginDao;
import de.terrestris.shoguncore.model.Application;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.Plugin;
import de.terrestris.shoguncore.service.ApplicationService;
import de.terrestris.shoguncore.service.PermissionAwareCrudService;
import java.util.ArrayList;
import java.util.List;
import org.h2.util.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pluginService")
public class PluginService<E extends Plugin, D extends PluginDao<E>>
extends PermissionAwareCrudService<E, D> {
    @Value(value="${plugin.namespace:Plugin}")
    private String pluginNamespace;
    @Autowired
    @Qualifier(value="applicationService")
    private ApplicationService<Application, ApplicationDao<Application>> applicationService;

    public PluginService() {
        this(Plugin.class);
    }

    protected PluginService(Class<E> entityClass) {
        super(entityClass);
    }

    public String getPluginNamespace() {
        return this.pluginNamespace;
    }

    public void setPluginNamespace(String pluginNamespace) {
        this.pluginNamespace = pluginNamespace;
    }

    @Transactional(readOnly=true)
    public String getPluginSource(String simpleClassName) throws Exception {
        String className = this.pluginNamespace + "." + simpleClassName;
        SimpleExpression criterion = Restrictions.eq((String)"className", (Object)className);
        Plugin plugin = (Plugin)((PluginDao)this.dao).findByUniqueCriteria(new Criterion[]{criterion});
        String code = null;
        if (plugin != null) {
            code = plugin.getSourceCode();
        }
        if (StringUtils.isNullOrEmpty(code)) {
            throw new Exception("Could not retrieve code for '" + className + "'");
        }
        return code;
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#pluginId, 'de.terrestris.shoguncore.model.Plugin', 'DELETE')")
    @Transactional(readOnly=true)
    public List<String> preCheckDelete(Integer pluginId) {
        ArrayList<String> result = new ArrayList<String>();
        Plugin plugin = (Plugin)((PluginDao)this.dao).findById(pluginId);
        if (plugin != null) {
            List appsWithPlugin = this.applicationService.findAllWithCollectionContaining("plugins", plugin);
            for (Application application : appsWithPlugin) {
                result.add(application.getName());
            }
        }
        return result;
    }

    @Override
    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#plugin, 'DELETE')")
    public void delete(E plugin) {
        if (this.applicationService == null) {
            this.LOG.error("Plugin cannot be deleted, failed to autowire application service");
            return;
        }
        List apps = this.applicationService.findAllWithCollectionContaining("plugins", (PersistentObject)plugin);
        Integer pluginId = ((PersistentObject)plugin).getId();
        for (Application app : apps) {
            List<Plugin> plugins = app.getPlugins();
            if (plugins == null || !plugins.contains(plugin)) continue;
            String msg = String.format("Remove plugin (id=%s) from application (id=%s)", pluginId, app.getId());
            this.LOG.debug(msg);
            plugins.remove(plugin);
            this.applicationService.saveOrUpdate(app);
        }
        this.LOG.debug(String.format("Delete plugin (id=%s)", pluginId));
        super.delete(plugin);
    }

    @Override
    @Autowired
    @Qualifier(value="pluginDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    public void setApplicationService(ApplicationService<Application, ApplicationDao<Application>> applicationService) {
        this.applicationService = applicationService;
    }
}

