/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.model.security.PermissionCollection;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;

@MappedSuperclass
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class PersistentObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    @Column(updatable=false, nullable=false)
    private final Integer id = null;
    @Column(updatable=false)
    @Type(type="org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    private final ReadableDateTime created;
    @Column
    @Type(type="org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    private ReadableDateTime modified;
    @ManyToMany
    @JoinTable(name="USERPERMISSIONS", joinColumns={@JoinColumn(name="ENTITY_ID")})
    @JsonIgnore
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Map<User, PermissionCollection> userPermissions = new HashMap<User, PermissionCollection>();
    @ManyToMany
    @JoinTable(name="GROUPPERMISSIONS", joinColumns={@JoinColumn(name="ENTITY_ID")})
    @JsonIgnore
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Map<UserGroup, PermissionCollection> groupPermissions = new HashMap<UserGroup, PermissionCollection>();

    protected PersistentObject() {
        this.created = DateTime.now();
        this.modified = DateTime.now();
    }

    public Integer getId() {
        return this.id;
    }

    @JsonIgnore
    public ReadableDateTime getCreated() {
        return this.created;
    }

    @JsonIgnore
    public ReadableDateTime getModified() {
        return this.modified;
    }

    public void setModified(ReadableDateTime modified) {
        this.modified = modified;
    }

    public Map<User, PermissionCollection> getUserPermissions() {
        return this.userPermissions;
    }

    public void setUserPermissions(Map<User, PermissionCollection> userPermissions) {
        this.userPermissions = userPermissions;
    }

    public Map<UserGroup, PermissionCollection> getGroupPermissions() {
        return this.groupPermissions;
    }

    public void setGroupPermissions(Map<UserGroup, PermissionCollection> groupPermissions) {
        this.groupPermissions = groupPermissions;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 43).append(this.getClass()).append((Object)this.getCreated()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PersistentObject)) {
            return false;
        }
        PersistentObject other = (PersistentObject)obj;
        return new EqualsBuilder().append(this.getClass(), other.getClass()).append((Object)this.getCreated(), (Object)other.getCreated()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("created", (Object)this.getCreated()).append("modified", (Object)this.getModified()).toString();
    }
}

