/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.rest;

import de.terrestris.shoguncore.dao.UserGroupDao;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.rest.AbstractRestController;
import de.terrestris.shoguncore.service.UserGroupService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/groups"})
public class UserGroupRestController<E extends UserGroup, D extends UserGroupDao<E>, S extends UserGroupService<E, D>>
extends AbstractRestController<E, D, S> {
    public UserGroupRestController() {
        this(UserGroup.class);
    }

    protected UserGroupRestController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="userGroupService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"/{groupId}/users"}, method={RequestMethod.GET})
    public ResponseEntity<Set<User>> findUsersOfGroup(@PathVariable Integer groupId) {
        try {
            Set<User> groupUsersSet = ((UserGroupService)this.service).getUsersOfGroup(groupId);
            return new ResponseEntity(groupUsersSet, HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOG.error("Error finding group with id " + groupId + ": " + e.getMessage());
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}

