/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.PasswordResetTokenDao;
import de.terrestris.shoguncore.dao.UserDao;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.token.PasswordResetToken;
import de.terrestris.shoguncore.service.AbstractUserTokenService;
import de.terrestris.shoguncore.service.UserService;
import de.terrestris.shoguncore.util.application.ShogunCoreContextUtil;
import de.terrestris.shoguncore.util.mail.MailPublisher;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service(value="passwordResetTokenService")
public class PasswordResetTokenService<E extends PasswordResetToken, D extends PasswordResetTokenDao<E>>
extends AbstractUserTokenService<E, D> {
    @Autowired
    private UserService<User, UserDao<User>> userService;
    @Autowired
    private UserDao<User> userDao;
    @Autowired
    private MailPublisher mailPublisher;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    @Qualifier(value="resetPasswordMailMessageTemplate")
    private SimpleMailMessage resetPasswordMailMessageTemplate;
    @Autowired
    private String changePasswordPath;

    public PasswordResetTokenService() {
        this(PasswordResetToken.class);
    }

    protected PasswordResetTokenService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="passwordResetTokenDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    @Override
    protected E buildConcreteInstance(User user, Integer expirationTimeInMinutes) {
        if (expirationTimeInMinutes == null) {
            return (E)new PasswordResetToken(user);
        }
        return (E)new PasswordResetToken(user, expirationTimeInMinutes);
    }

    public void sendResetPasswordMail(HttpServletRequest request, String email) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, URISyntaxException, UnsupportedEncodingException {
        User user = this.userDao.findByEmail(email);
        if (user == null) {
            throw new UsernameNotFoundException("Could not find user with email: '" + email + "'");
        }
        PasswordResetToken resetPasswordToken = (PasswordResetToken)this.getValidTokenForUser(user, null);
        URI resetPasswordURI = this.createResetPasswordURI(request, resetPasswordToken);
        SimpleMailMessage resetPwdMsg = new SimpleMailMessage(this.resetPasswordMailMessageTemplate);
        resetPwdMsg.setTo(email);
        resetPwdMsg.setText(String.format(resetPwdMsg.getText(), user.getFirstName(), user.getLastName(), UriUtils.decode((String)resetPasswordURI.toString(), (String)"UTF-8")));
        this.mailPublisher.sendMail(resetPwdMsg);
    }

    public void validateTokenAndUpdatePassword(String rawPassword, String token) throws Exception {
        PasswordResetToken passwordResetToken = (PasswordResetToken)this.findByTokenValue(token);
        this.validateToken(passwordResetToken);
        User user = passwordResetToken.getUser();
        this.userService.updatePassword(user, rawPassword);
        ((PasswordResetTokenDao)this.dao).delete(passwordResetToken);
        this.LOG.trace("Deleted the token.");
        this.LOG.debug("Successfully updated the password.");
    }

    private URI createResetPasswordURI(HttpServletRequest request, PasswordResetToken resetPasswordToken) throws URISyntaxException {
        URI appURI = ShogunCoreContextUtil.getApplicationURIFromRequest(request);
        URI tokenURI = new URIBuilder(appURI).setPath(appURI.getPath() + this.changePasswordPath).setParameter("token", resetPasswordToken.getToken()).build();
        return tokenURI;
    }

    public MailPublisher getMailPublisher() {
        return this.mailPublisher;
    }

    public void setMailPublisher(MailPublisher mailPublisher) {
        this.mailPublisher = mailPublisher;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public SimpleMailMessage getResetPasswordMailMessageTemplate() {
        return this.resetPasswordMailMessageTemplate;
    }

    public void setResetPasswordMailMessageTemplate(SimpleMailMessage resetPasswordMailMessageTemplate) {
        this.resetPasswordMailMessageTemplate = resetPasswordMailMessageTemplate;
    }

    public String getChangePasswordPath() {
        return this.changePasswordPath;
    }

    public void setChangePasswordPath(String changePasswordPath) {
        this.changePasswordPath = changePasswordPath;
    }
}

