/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.layer.source;

import de.terrestris.shoguncore.model.layer.source.LayerDataSource;
import de.terrestris.shoguncore.model.layer.util.WmtsTileGrid;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table
@Cacheable
public class WmtsLayerDataSource
extends LayerDataSource {
    private static final long serialVersionUID = 1L;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="TILEGRID_ID")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private WmtsTileGrid tileGrid;
    @ElementCollection(targetClass=String.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private List<String> urls;
    private String wmtsLayer;
    private String wmtsStyle;
    private String projection;
    private String matrixSet;
    private String requestEncoding;

    public WmtsLayerDataSource() {
    }

    public WmtsLayerDataSource(WmtsTileGrid tileGrid, String wmtsLayer, String wmtsStyle, String projection, String matrixSet, String requestEncoding, List<String> urls) {
        this();
        this.tileGrid = tileGrid;
        this.wmtsLayer = wmtsLayer;
        this.wmtsStyle = wmtsStyle;
        this.projection = projection;
        this.matrixSet = matrixSet;
        this.requestEncoding = requestEncoding;
        this.urls = urls;
    }

    public WmtsTileGrid getTileGrid() {
        return this.tileGrid;
    }

    public void setTileGrid(WmtsTileGrid tileGrid) {
        this.tileGrid = tileGrid;
    }

    public String getWmtsLayer() {
        return this.wmtsLayer;
    }

    public void setWmtsLayer(String wmtsLayer) {
        this.wmtsLayer = wmtsLayer;
    }

    public String getWmtsStyle() {
        return this.wmtsStyle;
    }

    public void setWmtsStyle(String wmtsStyle) {
        this.wmtsStyle = wmtsStyle;
    }

    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    public String getMatrixSet() {
        return this.matrixSet;
    }

    public void setMatrixSet(String matrixSet) {
        this.matrixSet = matrixSet;
    }

    public String getRequestEncoding() {
        return this.requestEncoding;
    }

    public void setRequestEncoding(String requestEncoding) {
        this.requestEncoding = requestEncoding;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(11, 19).appendSuper(super.hashCode()).append((Object)this.getRequestEncoding()).append((Object)this.getWmtsLayer()).append((Object)this.getMatrixSet()).append((Object)this.getProjection()).append((Object)this.getWmtsStyle()).append((Object)this.getTileGrid()).append(this.getUrls()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WmtsLayerDataSource)) {
            return false;
        }
        WmtsLayerDataSource other = (WmtsLayerDataSource)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getRequestEncoding(), (Object)other.getRequestEncoding()).append((Object)this.getWmtsLayer(), (Object)other.getWmtsLayer()).append((Object)this.getMatrixSet(), (Object)other.getMatrixSet()).append((Object)this.getProjection(), (Object)other.getProjection()).append((Object)this.getWmtsStyle(), (Object)other.getWmtsStyle()).append((Object)this.getTileGrid(), (Object)other.getTileGrid()).append(this.getUrls(), other.getUrls()).isEquals();
    }
}

