/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.impl;

import de.terrestris.shoguncore.util.interceptor.GeoserverAuthHeaderRequest;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WpsRequestInterceptorInterface;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

public class WpsRequestInterceptor
implements WpsRequestInterceptorInterface {
    private static final Logger LOG = LogManager.getLogger(WpsRequestInterceptor.class);
    @Value(value="${geoserver.username:}")
    private String gsUser;
    @Value(value="${geoserver.password:}")
    private String gsPass;

    @Override
    public MutableHttpServletRequest interceptGetCapabilities(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WPS GetCapabilities and adding Basic auth credentials.");
        return new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptDescribeProcess(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WPS DescribeProcess and adding Basic auth credentials.");
        return new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }

    @Override
    public MutableHttpServletRequest interceptExecute(MutableHttpServletRequest request) {
        LOG.debug("Intercepting WPS Execute and adding Basic auth credentials.");
        return new GeoserverAuthHeaderRequest((HttpServletRequest)request, this.gsUser, this.gsPass);
    }
}

