/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.terrestris.shoguncore.converter.PluginIdResolver;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.Plugin;
import de.terrestris.shoguncore.model.module.CompositeModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.joda.time.ReadableDateTime;

@Entity
@Table
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Application
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    @Column(nullable=false)
    private String name;
    @Column
    private String description;
    @Column
    private Locale language;
    @Column
    private Boolean open = true;
    @Column
    private Boolean active = true;
    @Column
    private String url;
    @ManyToOne
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private CompositeModule viewport;
    @ManyToMany
    @JoinTable(joinColumns={@JoinColumn(name="APPLICATION_ID")}, inverseJoinColumns={@JoinColumn(name="PLUGIN_ID")})
    @OrderColumn(name="IDX")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", resolver=PluginIdResolver.class)
    @JsonIdentityReference(alwaysAsId=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Plugin> plugins = new ArrayList<Plugin>();

    public Application() {
    }

    public Application(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    @JsonIgnore(value=false)
    public ReadableDateTime getCreated() {
        return super.getCreated();
    }

    @Override
    @JsonIgnore(value=false)
    public ReadableDateTime getModified() {
        return super.getModified();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public Boolean getOpen() {
        return this.open;
    }

    public void setOpen(Boolean open) {
        this.open = open;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CompositeModule getViewport() {
        return this.viewport;
    }

    public void setViewport(CompositeModule viewport) {
        this.viewport = viewport;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(29, 11).appendSuper(super.hashCode()).append((Object)this.getName()).append((Object)this.getDescription()).append((Object)this.getLanguage()).append((Object)this.getOpen()).append((Object)this.getActive()).append((Object)this.getUrl()).append((Object)this.getViewport()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getName(), (Object)other.getName()).append((Object)this.getDescription(), (Object)other.getDescription()).append((Object)this.getLanguage(), (Object)other.getLanguage()).append((Object)this.getOpen(), (Object)other.getOpen()).append((Object)this.getActive(), (Object)other.getActive()).append((Object)this.getUrl(), (Object)other.getUrl()).append((Object)this.getViewport(), (Object)other.getViewport()).isEquals();
    }
}

