/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.terrestris.shoguncore.dao.GenericHibernateDao;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.service.AbstractCrudService;
import de.terrestris.shoguncore.web.AbstractWebController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/rest"})
public abstract class AbstractRestController<E extends PersistentObject, D extends GenericHibernateDao<E, Integer>, S extends AbstractCrudService<E, D>>
extends AbstractWebController<E, D, S> {
    @Autowired
    protected ObjectMapper objectMapper;

    protected AbstractRestController(Class<E> entityClass) {
        super(entityClass);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<List<E>> findAll(@RequestParam MultiValueMap<String, String> requestParams) {
        List resultList = this.service.findAllRestricted(requestParams);
        if (resultList != null && !resultList.isEmpty()) {
            logger.trace("Found a total of " + resultList.size() + " entities of type " + ((PersistentObject)resultList.get(0)).getClass().getSimpleName());
        }
        return new ResponseEntity(resultList, HttpStatus.OK);
    }

    @RequestMapping(value={"/filter"}, method={RequestMethod.GET})
    public ResponseEntity<List<E>> findBySimpleFilter(@RequestParam MultiValueMap<String, String> requestParams) {
        List resultList = this.service.findBySimpleFilter(requestParams);
        if (resultList != null && !resultList.isEmpty()) {
            logger.trace("Found a total of " + resultList.size() + " entities of type " + ((PersistentObject)resultList.get(0)).getClass().getSimpleName());
        }
        return new ResponseEntity(resultList, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<E> findById(@PathVariable Integer id) {
        try {
            Object entity = this.service.findById(id);
            logger.trace("Found " + entity.getClass().getSimpleName() + " with ID " + ((PersistentObject)entity).getId());
            return new ResponseEntity(entity, HttpStatus.OK);
        }
        catch (Exception e) {
            logger.error("Error finding entity with id " + id + ": " + e.getMessage());
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<E> save(HttpServletRequest request) {
        String simpleClassName = this.getEntityClass().getSimpleName();
        String errorMessagePrefix = "Error when saving entity of type " + simpleClassName + ": ";
        try (BufferedReader reader = request.getReader();){
            PersistentObject entity = (PersistentObject)this.objectMapper.readValue((Reader)reader, this.getEntityClass());
            Integer id = entity.getId();
            if (id != null) {
                logger.error(errorMessagePrefix + "ID value is set to " + id + ", but MUST be null");
                ResponseEntity responseEntity2 = new ResponseEntity(HttpStatus.BAD_REQUEST);
                return responseEntity2;
            }
            this.service.saveOrUpdate(entity);
            logger.trace("Created " + simpleClassName + " with ID " + entity.getId());
            ResponseEntity responseEntity = new ResponseEntity((Object)entity, HttpStatus.CREATED);
            return responseEntity;
        }
        catch (IOException | RuntimeException e) {
            logger.error(errorMessagePrefix + e.getMessage());
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<E> update(@PathVariable int id, HttpServletRequest request) {
        String errorPrefix = "Error updating " + this.getEntityClass().getSimpleName() + " with ID " + id + ": ";
        try (BufferedReader reader = request.getReader();){
            JsonNode jsonObject = this.objectMapper.readTree((Reader)reader);
            if (jsonObject == null || !jsonObject.has("id")) {
                logger.error(errorPrefix + "The JSON body is empty or has no 'id' property.");
                ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            int payloadId = jsonObject.get("id").asInt();
            if (payloadId != id) {
                logger.error(errorPrefix + "Requested to update entity with ID " + id + ", but payload ID is " + payloadId);
                ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            Object entity = this.service.findById(id);
            if (entity != null) {
                entity = this.service.updatePartialWithJsonNode(entity, jsonObject, this.objectMapper);
                ResponseEntity responseEntity = new ResponseEntity(entity, HttpStatus.OK);
                return responseEntity;
            }
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (IOException | RuntimeException e) {
            logger.error(errorPrefix + e.getMessage());
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<E> delete(@PathVariable int id) {
        try {
            Object entityToDelete = this.service.findById(id);
            this.service.delete(entityToDelete);
            String proxyClassName = entityToDelete.getClass().getSimpleName();
            String simpleClassName = StringUtils.substringBefore((String)proxyClassName, (String)"_$$_");
            logger.trace("Deleted " + simpleClassName + " with ID " + id);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            logger.error("Error deleting entity with ID " + id + ": " + e.getMessage());
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }
}

