/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OgcEnum {
    public static final Map<ServiceType, Set<OperationType>> OPERATIONS_BY_SERVICETYPE;
    public static final Map<OperationType, Set<ServiceType>> SERVICETYPES_BY_OPERATION;

    static {
        HashMap map = new HashMap();
        HashSet<OperationType> wmsOps = new HashSet<OperationType>();
        wmsOps.add(OperationType.GET_CAPABILITIES);
        wmsOps.add(OperationType.GET_MAP);
        wmsOps.add(OperationType.GET_FEATURE_INFO);
        wmsOps.add(OperationType.DESCRIBE_LAYER);
        wmsOps.add(OperationType.GET_LEGEND_GRAPHIC);
        wmsOps.add(OperationType.GET_STYLES);
        HashSet<OperationType> wfsOps = new HashSet<OperationType>();
        wfsOps.add(OperationType.GET_CAPABILITIES);
        wfsOps.add(OperationType.DESCRIBE_FEATURE_TYPE);
        wfsOps.add(OperationType.GET_FEATURE);
        wfsOps.add(OperationType.LOCK_FEATURE);
        wfsOps.add(OperationType.TRANSACTION);
        HashSet<OperationType> wcsOps = new HashSet<OperationType>();
        wcsOps.add(OperationType.GET_CAPABILITIES);
        wcsOps.add(OperationType.DESCRIBE_COVERAGE);
        wcsOps.add(OperationType.GET_COVERAGE);
        HashSet<OperationType> wpsOps = new HashSet<OperationType>();
        wpsOps.add(OperationType.GET_CAPABILITIES);
        wpsOps.add(OperationType.EXECUTE);
        wpsOps.add(OperationType.DESCRIBE_PROCESS);
        HashSet<OperationType> w3dsOps = new HashSet<OperationType>();
        w3dsOps.add(OperationType.GET_CAPABILITIES);
        w3dsOps.add(OperationType.GET_SCENE);
        w3dsOps.add(OperationType.GET_FEATURE_INFO);
        w3dsOps.add(OperationType.GET_LAYER_INFO);
        w3dsOps.add(OperationType.GET_TILE);
        map.put(ServiceType.WMS, Collections.unmodifiableSet(wmsOps));
        map.put(ServiceType.WFS, Collections.unmodifiableSet(wfsOps));
        map.put(ServiceType.WCS, Collections.unmodifiableSet(wcsOps));
        map.put(ServiceType.WPS, Collections.unmodifiableSet(wpsOps));
        map.put(ServiceType.W3DS, Collections.unmodifiableSet(w3dsOps));
        OPERATIONS_BY_SERVICETYPE = Collections.unmodifiableMap(map);
        map = new HashMap();
        Set<ServiceType> wmsSet = new HashSet<ServiceType>();
        wmsSet.add(ServiceType.WMS);
        wmsSet = Collections.unmodifiableSet(wmsSet);
        Set<ServiceType> wfsSet = new HashSet<ServiceType>();
        wfsSet.add(ServiceType.WFS);
        wfsSet = Collections.unmodifiableSet(wfsSet);
        Set<ServiceType> wcsSet = new HashSet<ServiceType>();
        wcsSet.add(ServiceType.WCS);
        wcsSet = Collections.unmodifiableSet(wcsSet);
        Set<ServiceType> wpsSet = new HashSet<ServiceType>();
        wpsSet.add(ServiceType.WPS);
        wpsSet = Collections.unmodifiableSet(wpsSet);
        Set<ServiceType> getCapSet = new HashSet<ServiceType>();
        getCapSet.add(ServiceType.WMS);
        getCapSet.add(ServiceType.WFS);
        getCapSet.add(ServiceType.WCS);
        getCapSet.add(ServiceType.WPS);
        getCapSet = Collections.unmodifiableSet(getCapSet);
        Set<OperationType> wmsOperations = OPERATIONS_BY_SERVICETYPE.get((Object)ServiceType.WMS);
        Set<OperationType> wfsOperations = OPERATIONS_BY_SERVICETYPE.get((Object)ServiceType.WFS);
        Set<OperationType> wcsOperations = OPERATIONS_BY_SERVICETYPE.get((Object)ServiceType.WCS);
        Set<OperationType> wpsOperations = OPERATIONS_BY_SERVICETYPE.get((Object)ServiceType.WPS);
        map.put(OperationType.GET_CAPABILITIES, getCapSet);
        for (OperationType wmsOperation : wmsOperations) {
            if (OperationType.GET_CAPABILITIES.equals((Object)wmsOperation)) continue;
            map.put(wmsOperation, wmsSet);
        }
        for (OperationType wfsOperation : wfsOperations) {
            if (OperationType.GET_CAPABILITIES.equals((Object)wfsOperation)) continue;
            map.put(wfsOperation, wfsSet);
        }
        for (OperationType wcsOperation : wcsOperations) {
            if (OperationType.GET_CAPABILITIES.equals((Object)wcsOperation)) continue;
            map.put(wcsOperation, wcsSet);
        }
        for (OperationType wpsOperation : wpsOperations) {
            if (OperationType.GET_CAPABILITIES.equals((Object)wpsOperation)) continue;
            map.put(wpsOperation, wpsSet);
        }
        SERVICETYPES_BY_OPERATION = Collections.unmodifiableMap(map);
    }

    public static enum OperationType {
        GET_MAP("GetMap"),
        GET_CAPABILITIES("GetCapabilities"),
        GET_FEATURE_INFO("GetFeatureInfo"),
        DESCRIBE_LAYER("DescribeLayer"),
        GET_LEGEND_GRAPHIC("GetLegendGraphic"),
        GET_STYLES("GetStyles"),
        DESCRIBE_FEATURE_TYPE("DescribeFeatureType"),
        GET_FEATURE("GetFeature"),
        LOCK_FEATURE("LockFeature"),
        TRANSACTION("Transaction"),
        DESCRIBE_COVERAGE("DescribeCoverage"),
        GET_COVERAGE("GetCoverage"),
        EXECUTE("Execute"),
        DESCRIBE_PROCESS("DescribeProcess"),
        GET_SCENE("GetScene"),
        GET_LAYER_INFO("GetLayerInfo"),
        GET_TILE("GetTile");

        private final String value;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperationType fromString(String inputValue) {
            if (inputValue != null) {
                for (OperationType type : OperationType.values()) {
                    if (!inputValue.equalsIgnoreCase(type.value)) continue;
                    return type;
                }
            }
            return null;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum ServiceType {
        WMS("WMS"),
        WFS("WFS"),
        WCS("WCS"),
        WPS("WPS"),
        W3DS("W3DS");

        private final String value;

        private ServiceType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ServiceType fromString(String inputValue) {
            if (inputValue != null) {
                for (ServiceType type : ServiceType.values()) {
                    if (!inputValue.equalsIgnoreCase(type.value)) continue;
                    return type;
                }
            }
            return null;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum EndPoint {
        LAYERS("LAYERS"),
        LAYER("LAYER"),
        TYPENAME("TYPENAME"),
        TYPENAMES("TYPENAMES"),
        NAMESPACE("NAMESPACE");

        private final String value;

        private EndPoint(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EndPoint fromString(String inputValue) {
            if (inputValue != null) {
                for (EndPoint type : EndPoint.values()) {
                    if (!inputValue.equalsIgnoreCase(type.value)) continue;
                    return type;
                }
            }
            return null;
        }

        public static String[] getAllValues() {
            EndPoint[] endPoints = EndPoint.values();
            String[] values = new String[endPoints.length];
            for (int i = 0; i < endPoints.length; ++i) {
                values[i] = endPoints[i].value;
            }
            return values;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum Operation {
        OPERATION("REQUEST");

        private final String value;

        private Operation(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperationType fromString(String inputValue) {
            if (inputValue != null) {
                for (OperationType type : OperationType.values()) {
                    if (!inputValue.equalsIgnoreCase(type.value)) continue;
                    return type;
                }
            }
            return null;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum Service {
        SERVICE("SERVICE");

        private final String value;

        private Service(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Service fromString(String inputValue) {
            if (inputValue != null) {
                for (Service type : Service.values()) {
                    if (!inputValue.equalsIgnoreCase(type.value)) continue;
                    return type;
                }
            }
            return null;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

