/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.web;

import de.terrestris.shoguncore.service.Csv2ExtJsLocaleService;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/locale"})
public class Csv2ExtJsLocaleController {
    private static final Logger logger = LogManager.getLogger(Csv2ExtJsLocaleController.class);
    @Autowired
    private Csv2ExtJsLocaleService service;

    @RequestMapping(value={"/{appId}/{locale}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getAllComponentsForLocale(@PathVariable String appId, @PathVariable String locale) {
        if (appId == null || appId.isEmpty()) {
            return null;
        }
        if (locale == null || locale.isEmpty()) {
            return null;
        }
        logger.debug("Trying to get all EXT JS locale components of app '" + appId + "' for locale: '" + locale + "'");
        HashMap<String, Object> resultMap = new HashMap();
        try {
            resultMap = this.service.getAllComponentsForLocale(appId, locale);
        }
        catch (Exception e) {
            String errorMessage = "Could not generate an EXT JS locale JSON from a CSV: " + e.getMessage();
            resultMap.put("success", false);
            resultMap.put("message", errorMessage);
        }
        return resultMap;
    }

    public Csv2ExtJsLocaleService getService() {
        return this.service;
    }

    public void setService(Csv2ExtJsLocaleService service) {
        this.service = service;
    }
}

