/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.LayerDao;
import de.terrestris.shoguncore.dao.MapDao;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.model.module.Map;
import de.terrestris.shoguncore.service.MapService;
import de.terrestris.shoguncore.service.PermissionAwareCrudService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service(value="layerService")
public class LayerService<E extends Layer, D extends LayerDao<E>>
extends PermissionAwareCrudService<E, D> {
    @Autowired
    @Qualifier(value="mapService")
    MapService<Map, MapDao<Map>> mapService;

    public LayerService() {
        this(Layer.class);
    }

    protected LayerService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="layerDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    @Override
    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#layer, 'DELETE')")
    public void delete(E layer) {
        Set<Map> maps = this.mapService.findMapsWithLayer((Layer)layer);
        logger.info("Found " + maps.size() + " maps with layer " + layer);
        for (Map map : maps) {
            map.getMapLayers().remove(layer);
            this.mapService.saveOrUpdate(map);
            logger.info("Removed layer from map");
        }
        super.delete(layer);
    }
}

