/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.helper;

import de.terrestris.shoguncore.model.PersistentObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IdHelper {
    private static final Logger logger = LogManager.getLogger(IdHelper.class);

    public static final void setIdOnPersistentObject(PersistentObject persistentObject, Integer id) throws NoSuchFieldException, IllegalAccessException {
        Field idField = PersistentObject.class.getDeclaredField("id");
        AccessController.doPrivileged(() -> {
            idField.setAccessible(true);
            try {
                idField.set(persistentObject, id);
            }
            catch (IllegalAccessException e) {
                logger.error("Could not set ID field for persistent object", (Throwable)e);
            }
            idField.setAccessible(false);
            return null;
        });
    }
}

