/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.init;

import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.service.InitializationService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ContentInitializer {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    protected InitializationService initService;
    @Autowired
    @Qualifier(value="shogunInitEnabled")
    private Boolean shogunInitEnabled;
    @Resource
    @Qualifier(value="objectsToCreate")
    private List<PersistentObject> objectsToCreate;

    public void initializeDatabaseContent() {
        if (this.shogunInitEnabled.booleanValue()) {
            this.logger.info("Initializing SHOGun content");
            for (PersistentObject object : this.objectsToCreate) {
                if (object instanceof User) {
                    this.initService.saveUser((User)object);
                    continue;
                }
                this.initService.savePersistentObject(object);
            }
        } else {
            this.logger.info("Not initializing anything for SHOGun.");
        }
    }

    public void setShogunInitEnabled(Boolean shogunInitEnabled) {
        this.shogunInitEnabled = shogunInitEnabled;
    }

    public void setInitService(InitializationService initService) {
        this.initService = initService;
    }

    public void setObjectsToCreate(List<PersistentObject> objectsToCreate) {
        this.objectsToCreate = objectsToCreate;
    }
}

