/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.module;

import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.model.map.MapConfig;
import de.terrestris.shoguncore.model.map.MapControl;
import de.terrestris.shoguncore.model.module.Module;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table
@Cacheable
public class Map
extends Module {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private MapConfig mapConfig;
    @ManyToMany
    @JoinTable(joinColumns={@JoinColumn(name="MAP_ID")}, inverseJoinColumns={@JoinColumn(name="CONTROL_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Set<MapControl> mapControls = new HashSet<MapControl>();
    @ManyToMany
    @JoinTable(joinColumns={@JoinColumn(name="MAP_ID")}, inverseJoinColumns={@JoinColumn(name="LAYER_ID")})
    @OrderColumn(name="IDX")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private List<Layer> mapLayers = new ArrayList<Layer>();

    public Map() {
    }

    public Map(String name, MapConfig mapConfig, List<Layer> mapLayers) {
        super(name);
        this.mapConfig = mapConfig;
        this.mapLayers = mapLayers;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public Set<MapControl> getMapControls() {
        return this.mapControls;
    }

    public void setMapControls(Set<MapControl> mapControls) {
        this.mapControls = mapControls;
    }

    public List<Layer> getMapLayers() {
        return this.mapLayers;
    }

    public void setMapLayers(List<Layer> mapLayers) {
        this.mapLayers = mapLayers;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(47, 11).appendSuper(super.hashCode()).append((Object)this.getMapConfig()).append(this.getMapControls()).append(this.getMapLayers()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return new EqualsBuilder().append((Object)this.getMapConfig(), (Object)other.getMapConfig()).append(this.getMapControls(), other.getMapControls()).append(this.getMapLayers(), other.getMapLayers()).isEquals();
    }
}

