/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.FileDao;
import de.terrestris.shoguncore.model.File;
import de.terrestris.shoguncore.service.PermissionAwareCrudService;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="fileService")
public class FileService<E extends File, D extends FileDao<E>>
extends PermissionAwareCrudService<E, D> {
    public FileService() {
        this(File.class);
    }

    protected FileService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="fileDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    @PreAuthorize(value="isAuthenticated()")
    public E uploadFile(MultipartFile file) throws Exception {
        if (file == null) {
            String errMsg = "Upload failed. File is null.";
            logger.error("Upload failed. File is null.");
            throw new Exception("Upload failed. File is null.");
        }
        if (file.isEmpty()) {
            String errMsg = "Upload failed. File is empty.";
            logger.error("Upload failed. File is empty.");
            throw new Exception("Upload failed. File is empty.");
        }
        InputStream is = null;
        byte[] fileByteArray = null;
        File fileToPersist = (File)this.getEntityClass().newInstance();
        try {
            is = file.getInputStream();
            fileByteArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new Exception("Could not create the bytearray: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        fileToPersist.setFile(fileByteArray);
        fileToPersist.setFileType(file.getContentType());
        fileToPersist.setFileName(file.getOriginalFilename());
        ((FileDao)this.dao).saveOrUpdate(fileToPersist);
        return (E)fileToPersist;
    }
}

