/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.util.http.HttpUtil;
import de.terrestris.shoguncore.util.model.Response;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service(value="httpProxyService")
public class HttpProxyService {
    public static final String ERR_MSG_400_NO_URL = "ERROR 400 (Bad Request): The HttpProxyService could not determine a URL to proxy to.";
    public static final String ERR_MSG_400_COMMON = "ERROR 400 (Bad Request): Please check the log files for details.";
    public static final String ERR_MSG_404 = "ERROR 404 (Not found): The HttpProxyService could not find the requested service.";
    public static final String ERR_MSG_405 = "ERROR 405: (Method Not Allowed): The HttpProxyService does not support this request method.";
    public static final String ERR_MSG_500 = "ERROR 500 (Internal Error) An internal error occured which prevented further processing.";
    public static final String ERR_MSG_502 = "ERROR 502 (Bad Gateway): The HttpProxyService does not allow you to access that location.";
    private static final Logger LOG = LogManager.getLogger(HttpProxyService.class);
    private static final String CONTENT_TYPE_TEXT_PLAIN = MediaType.TEXT_PLAIN.toString();
    private static final ResponseEntity<String> RESPONSE_400_BAD_REQUEST_COMMON = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).header("Content-Type", new String[]{CONTENT_TYPE_TEXT_PLAIN})).body((Object)"ERROR 400 (Bad Request): Please check the log files for details.");
    private static final ResponseEntity<String> RESPONSE_400_BAD_REQUEST_NO_URL = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).header("Content-Type", new String[]{CONTENT_TYPE_TEXT_PLAIN})).body((Object)"ERROR 400 (Bad Request): The HttpProxyService could not determine a URL to proxy to.");
    private static final ResponseEntity<String> RESPONSE_404_NOT_FOUND = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).header("Content-Type", new String[]{CONTENT_TYPE_TEXT_PLAIN})).body((Object)"ERROR 404 (Not found): The HttpProxyService could not find the requested service.");
    private static final ResponseEntity<String> RESPONSE_405_METHOD_NOT_ALLOWED = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).header("Content-Type", new String[]{CONTENT_TYPE_TEXT_PLAIN})).body((Object)"ERROR 405: (Method Not Allowed): The HttpProxyService does not support this request method.");
    private static final ResponseEntity<String> RESPONSE_500_INTERNAL_SERVER_ERROR = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).header("Content-Type", new String[]{CONTENT_TYPE_TEXT_PLAIN})).body((Object)"ERROR 500 (Internal Error) An internal error occured which prevented further processing.");
    private static final ResponseEntity<String> RESPONSE_502_BAD_GATEWAY = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_GATEWAY).header("Content-Type", new String[]{CONTENT_TYPE_TEXT_PLAIN})).body((Object)"ERROR 502 (Bad Gateway): The HttpProxyService does not allow you to access that location.");
    private static final String UNQUOTED_SUBTYPE_GML = " subtype=gml/3.1.1";
    private static final String QUOTED_SUBTYPE_GML = " subtype=\"gml/3.1.1\"";
    private static final String HEADER_SUFFIX_UTF8_CHARSET = "; charset=utf-8";
    private static final String JSON_CONTENT_TYPE_HEADER = "application/json; charset=utf-8";
    private static final String CSV_CONTENT_TYPE_HEADER = "text/csv; charset=utf-8";
    private static final Set<String> CONTENT_TYPE_JSON_HINTS = new HashSet<String>(Arrays.asList("json", "application/json", "text/json"));
    private static final Set<String> CONTENT_TYPE_CSV_HINTS = new HashSet<String>(Arrays.asList("text/csv"));
    private static final Set<String> LC_UNSUPPORTED_HEADERS = new HashSet<String>(Arrays.asList("transfer-encoding"));
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    @Value(value="#{'${proxy.whitelist}'.split(',')}")
    private List<String> proxyWhiteList;

    public ResponseEntity<?> doProxy(HttpServletRequest request, String baseUrl, Map<String, String> params) {
        return this.doProxy(request, baseUrl, params, true);
    }

    public ResponseEntity<?> doProxy(HttpServletRequest request, String baseUrl, Map<String, String> params, boolean useWhitelist) {
        Response response;
        boolean isInWhiteList;
        URL url;
        LOG.debug("Intercepting a request against service '" + baseUrl + "' with parameters: " + params);
        if (StringUtils.isEmpty((CharSequence)baseUrl) || request == null) {
            LOG.warn(ERR_MSG_400_NO_URL);
            return RESPONSE_400_BAD_REQUEST_NO_URL;
        }
        try {
            url = new URL(baseUrl);
        }
        catch (MalformedURLException use) {
            LOG.error(RESPONSE_500_INTERNAL_SERVER_ERROR);
            return RESPONSE_500_INTERNAL_SERVER_ERROR;
        }
        if (useWhitelist && !(isInWhiteList = this.isInWhiteList(url))) {
            LOG.warn(ERR_MSG_502);
            return RESPONSE_502_BAD_GATEWAY;
        }
        try {
            url = this.buildUriWithParameters(url, params);
        }
        catch (MalformedURLException | URISyntaxException excep) {
            LOG.error(RESPONSE_500_INTERNAL_SERVER_ERROR);
            return RESPONSE_500_INTERNAL_SERVER_ERROR;
        }
        if (HttpUtil.isHttpGetRequest(request)) {
            try {
                LOG.debug("Forwarding as GET to: " + url);
                response = HttpUtil.forwardGet(url.toURI(), request, false);
            }
            catch (URISyntaxException | HttpException e) {
                String errorMessage = "Error forwarding GET request: " + e.getMessage();
                LOG.error(errorMessage);
                return RESPONSE_400_BAD_REQUEST_COMMON;
            }
        } else if (HttpUtil.isHttpPostRequest(request)) {
            if (HttpUtil.isFormMultipartPost(request)) {
                try {
                    LOG.debug("Forwarding as form/multipart POST");
                    response = HttpUtil.forwardFormMultipartPost(url.toURI(), request, false);
                }
                catch (IOException | IllegalStateException | URISyntaxException | ServletException | HttpException e) {
                    String errorMessage = "Error forwarding form/multipart POST request: " + e.getMessage();
                    LOG.error(errorMessage);
                    return RESPONSE_400_BAD_REQUEST_COMMON;
                }
            } else {
                try {
                    LOG.debug("Forwarding as POST");
                    response = HttpUtil.forwardPost(url.toURI(), request, false);
                }
                catch (URISyntaxException | HttpException e) {
                    String errorMessage = "Error forwarding POST request: " + e.getMessage();
                    LOG.error(errorMessage);
                    return RESPONSE_400_BAD_REQUEST_COMMON;
                }
            }
        } else {
            LOG.error("Proxy does not yet support HTTP method: " + request.getMethod());
            return RESPONSE_405_METHOD_NOT_ALLOWED;
        }
        byte[] bytes = response.getBody();
        HttpHeaders responseHeadersToForward = response.getHeaders();
        Set headerEntries = responseHeadersToForward.entrySet();
        for (Map.Entry headerEntry : headerEntries) {
            String headerKey = (String)headerEntry.getKey();
            List headerValues = (List)headerEntry.getValue();
            String joinedHeaderValues = StringUtils.join((Iterable)headerValues, (String)"; ");
            LOG.debug("Got the following response header: " + headerKey + "=" + joinedHeaderValues);
        }
        HttpStatus responseHttpStatus = response.getStatusCode();
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeadersToForward, responseHttpStatus);
    }

    private URL buildUriWithParameters(URL url, Map<String, String> params) throws URISyntaxException, MalformedURLException {
        if (params == null || params.isEmpty()) {
            return url;
        }
        URIBuilder uriBuilder = new URIBuilder(url.toURI());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            uriBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        return uriBuilder.build().toURL();
    }

    private boolean isInWhiteList(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        String protocol = url.getProtocol();
        int portToTest = -1;
        portToTest = port != -1 ? port : (StringUtils.equalsIgnoreCase((CharSequence)protocol, (CharSequence)"https") ? 443 : 80);
        int finalPortToTest = portToTest;
        List matchingWhiteListEntries = this.proxyWhiteList.stream().filter(whitelistEntry -> {
            int whitelistPort;
            String whitelistHost;
            if (StringUtils.contains((CharSequence)whitelistEntry, (CharSequence)":")) {
                whitelistHost = whitelistEntry.split(":")[0];
                whitelistPort = Integer.parseInt(whitelistEntry.split(":")[1]);
            } else {
                whitelistHost = whitelistEntry;
                whitelistPort = -1;
            }
            int portToTestAgainst = whitelistPort != -1 ? whitelistPort : (StringUtils.equalsIgnoreCase((CharSequence)protocol, (CharSequence)"https") ? 443 : 80);
            boolean portIsMatching = portToTestAgainst == finalPortToTest;
            boolean domainIsMatching = StringUtils.equalsIgnoreCase((CharSequence)host, (CharSequence)whitelistHost) || StringUtils.endsWith((CharSequence)host, (CharSequence)whitelistHost);
            return portIsMatching && domainIsMatching;
        }).collect(Collectors.toList());
        boolean isAllowed = !matchingWhiteListEntries.isEmpty();
        return isAllowed;
    }

    public void setProxyWhiteList(List<String> proxyWhiteList) {
        this.proxyWhiteList = proxyWhiteList;
    }
}

