/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.ImageFileDao;
import de.terrestris.shoguncore.model.File;
import de.terrestris.shoguncore.model.ImageFile;
import de.terrestris.shoguncore.service.FileService;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.imgscalr.Scalr;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="imageFileService")
public class ImageFileService<E extends ImageFile, D extends ImageFileDao<E>>
extends FileService<E, D> {
    private static final Integer DEFAULT_THUMBNAIL_SIZE = 100;

    public ImageFileService() {
        this(ImageFile.class);
    }

    protected ImageFileService(Class<E> entityClass) {
        super(entityClass);
    }

    public static byte[] scaleImage(byte[] imageBytes, String outputFormat, Integer targetSize) throws Exception {
        byte[] imageInBytes;
        Image image = null;
        Image resizedImage = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);){
            image = ImageIO.read(is);
            resizedImage = Scalr.resize((BufferedImage)image, (int)targetSize, (BufferedImageOp[])new BufferedImageOp[0]);
            ImageIO.write((RenderedImage)((Object)resizedImage), outputFormat, baos);
            imageInBytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new Exception("Error on resizing an image: " + e.getMessage());
        }
        finally {
            if (image != null) {
                image.flush();
            }
            if (resizedImage != null) {
                resizedImage.flush();
            }
        }
        return imageInBytes;
    }

    @Override
    @Autowired
    @Qualifier(value="imageFileDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    @Override
    @PreAuthorize(value="isAuthenticated()")
    public E uploadFile(MultipartFile file) throws Exception {
        if (file == null) {
            String errMsg = "Upload failed. Image is null.";
            logger.error("Upload failed. Image is null.");
            throw new Exception("Upload failed. Image is null.");
        }
        if (file.isEmpty()) {
            String errMsg = "Upload failed. Image " + file + " is empty.";
            logger.error(errMsg);
            throw new Exception(errMsg);
        }
        E image = this.saveImage(file, true, DEFAULT_THUMBNAIL_SIZE);
        logger.info("Successfully uploaded image " + ((File)image).getFileName());
        return image;
    }

    @PreAuthorize(value="isAuthenticated()")
    public E saveImage(MultipartFile file, boolean createThumbnail, Integer thumbnailTargetSize) throws Exception {
        InputStream is = null;
        ByteArrayInputStream bais = null;
        ImageFile imageToPersist = null;
        try {
            is = file.getInputStream();
            byte[] imageByteArray = IOUtils.toByteArray((InputStream)is);
            imageToPersist = (ImageFile)this.getEntityClass().newInstance();
            if (createThumbnail) {
                byte[] thumbnail = ImageFileService.scaleImage(imageByteArray, FilenameUtils.getExtension((String)file.getOriginalFilename()), thumbnailTargetSize);
                imageToPersist.setThumbnail(thumbnail);
            }
            imageToPersist.setFile(imageByteArray);
            bais = new ByteArrayInputStream(imageByteArray);
            BufferedImage bimg = ImageIO.read(bais);
            imageToPersist.setWidth(bimg.getWidth());
            imageToPersist.setHeight(bimg.getHeight());
            imageToPersist.setFileType(file.getContentType());
            imageToPersist.setFileName(file.getOriginalFilename());
            ((ImageFileDao)this.dao).saveOrUpdate(imageToPersist);
        }
        catch (Exception e) {
            try {
                throw new Exception("Could not create the Image in DB: " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)bais);
        return (E)imageToPersist;
    }
}

