/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.LayerDao;
import de.terrestris.shoguncore.dao.MapDao;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.model.module.Map;
import de.terrestris.shoguncore.service.LayerService;
import de.terrestris.shoguncore.service.ModuleService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mapService")
public class MapService<E extends Map, D extends MapDao<E>>
extends ModuleService<E, D> {
    @Autowired
    @Qualifier(value="layerService")
    private LayerService<Layer, LayerDao<Layer>> layerService;

    public MapService() {
        this(Map.class);
    }

    protected MapService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="mapDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#layer, 'READ')")
    @Transactional(readOnly=true)
    public Set<E> findMapsWithLayer(Layer layer) {
        return ((MapDao)this.dao).findMapsWithLayer(layer);
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#mapModuleId, 'de.terrestris.shoguncore.model.module.Map', 'UPDATE')")
    public List<Layer> setLayersForMap(Integer mapModuleId, List<Integer> layerIds) throws Exception {
        Map module = (Map)this.findById(mapModuleId);
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Integer id : layerIds) {
            Object entity = this.layerService.findById(id);
            Layer layer = (Layer)entity;
            if (layer == null) continue;
            layers.add(layer);
        }
        module.setMapLayers(layers);
        this.saveOrUpdate(module);
        return layers;
    }
}

