/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor;

import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class GeoserverAuthHeaderRequest
extends MutableHttpServletRequest {
    private final String encoding;

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public GeoserverAuthHeaderRequest(HttpServletRequest request, String user, String password) {
        super(request);
        this.encoding = "Basic " + Base64.getEncoder().encodeToString(user.concat(":").concat(password).getBytes());
    }

    @Override
    public String getHeader(String name) {
        if (name.equals("x-geoserver-credentials")) {
            return this.encoding;
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (name.equalsIgnoreCase("x-geoserver-credentials")) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.encoding);
            return Collections.enumeration(list);
        }
        return super.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList list = Collections.list(super.getHeaderNames());
        list.add("x-geoserver-credentials");
        return Collections.enumeration(list);
    }
}

