/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor;

import de.terrestris.shoguncore.util.enumeration.InterceptorEnum;
import de.terrestris.shoguncore.util.enumeration.OgcEnum;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class OgcMessage {
    @Enumerated(value=EnumType.STRING)
    private OgcEnum.ServiceType service;
    @Enumerated(value=EnumType.STRING)
    private OgcEnum.OperationType operation;
    private String endPoint;
    @Enumerated(value=EnumType.STRING)
    private InterceptorEnum.RuleType requestRule;
    @Enumerated(value=EnumType.STRING)
    private InterceptorEnum.RuleType responseRule;

    public OgcMessage() {
    }

    public OgcMessage(OgcEnum.ServiceType service, OgcEnum.OperationType operation, String endPoint, InterceptorEnum.RuleType requestRule, InterceptorEnum.RuleType responseRule) {
        this.service = service;
        this.operation = operation;
        this.endPoint = endPoint;
        this.requestRule = requestRule;
        this.responseRule = responseRule;
    }

    public OgcEnum.ServiceType getService() {
        return this.service;
    }

    public void setService(OgcEnum.ServiceType service) {
        this.service = service;
    }

    public OgcEnum.OperationType getOperation() {
        return this.operation;
    }

    public void setOperation(OgcEnum.OperationType operation) {
        this.operation = operation;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public InterceptorEnum.RuleType getRequestRule() {
        return this.requestRule;
    }

    public void setRequestRule(InterceptorEnum.RuleType requestRule) {
        this.requestRule = requestRule;
    }

    public InterceptorEnum.RuleType getResponseRule() {
        return this.responseRule;
    }

    public void setResponseRule(InterceptorEnum.RuleType responseRule) {
        this.responseRule = responseRule;
    }

    public boolean isWms() {
        return this.getService() != null && this.getService().equals((Object)OgcEnum.ServiceType.WMS);
    }

    public boolean isWfs() {
        return this.getService() != null && this.getService().equals((Object)OgcEnum.ServiceType.WFS);
    }

    public boolean isWcs() {
        return this.getService() != null && this.getService().equals((Object)OgcEnum.ServiceType.WCS);
    }

    public boolean isWps() {
        return this.getService() != null && this.getService().equals((Object)OgcEnum.ServiceType.WPS);
    }

    public boolean isW3ds() {
        return this.getService() != null && this.getService().equals((Object)OgcEnum.ServiceType.W3DS);
    }

    public boolean isWmsGetCapabilities() {
        return this.isWms() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_CAPABILITIES);
    }

    public boolean isWmsGetMap() {
        return this.isWms() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_MAP);
    }

    public boolean isWmsGetFeatureInfo() {
        return this.isWms() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_FEATURE_INFO);
    }

    public boolean isWmsDescribeLayer() {
        return this.isWms() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.DESCRIBE_LAYER);
    }

    public boolean isWmsGetLegendGraphic() {
        return this.isWms() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_LEGEND_GRAPHIC);
    }

    public boolean isWmsGetStyles() {
        return this.isWms() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_STYLES);
    }

    public boolean isWfsGetCapabilities() {
        return this.isWfs() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_CAPABILITIES);
    }

    public boolean isWfsDescribeFeatureType() {
        return this.isWfs() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.DESCRIBE_FEATURE_TYPE);
    }

    public boolean isWfsGetFeature() {
        return this.isWfs() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_FEATURE);
    }

    public boolean isWfsLockFeature() {
        return this.isWfs() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.LOCK_FEATURE);
    }

    public boolean isWfsTransaction() {
        return this.isWfs() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.TRANSACTION);
    }

    public boolean isWcsGetCapabilities() {
        return this.isWcs() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_CAPABILITIES);
    }

    public boolean isWcsDescribeCoverage() {
        return this.isWcs() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.DESCRIBE_COVERAGE);
    }

    public boolean isWcsGetCoverage() {
        return this.isWcs() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_COVERAGE);
    }

    public boolean isWpsGetCapabilities() {
        return this.isWps() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_CAPABILITIES);
    }

    public boolean isWpsDescribeProcess() {
        return this.isWps() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.DESCRIBE_PROCESS);
    }

    public boolean isWpsExecute() {
        return this.isWps() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.EXECUTE);
    }

    public boolean isW3dsGetCapabilities() {
        return this.isW3ds() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_CAPABILITIES);
    }

    public boolean isW3dsGetScene() {
        return this.isW3ds() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_SCENE);
    }

    public boolean isW3dsGetFeatureInfo() {
        return this.isW3ds() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_FEATURE_INFO);
    }

    public boolean isW3dsGetLayerInfo() {
        return this.isW3ds() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_LAYER_INFO);
    }

    public boolean isW3dsGetTile() {
        return this.isW3ds() && this.getOperation() != null && this.getOperation().equals((Object)OgcEnum.OperationType.GET_TILE);
    }

    public boolean isRequestAllowed() {
        return this.getRequestRule() != null && this.getRequestRule().equals((Object)InterceptorEnum.RuleType.ALLOW);
    }

    public boolean isResponseAllowed() {
        return this.getResponseRule() != null && this.getResponseRule().equals((Object)InterceptorEnum.RuleType.ALLOW);
    }

    public boolean isRequestDenied() {
        return this.getRequestRule() != null && this.getRequestRule().equals((Object)InterceptorEnum.RuleType.DENY);
    }

    public boolean isResponseDenied() {
        return this.getResponseRule() != null && this.getResponseRule().equals((Object)InterceptorEnum.RuleType.DENY);
    }

    public boolean isRequestModified() {
        return this.getRequestRule() != null && this.getRequestRule().equals((Object)InterceptorEnum.RuleType.MODIFY);
    }

    public boolean isResponseModified() {
        return this.getResponseRule() != null && this.getResponseRule().equals((Object)InterceptorEnum.RuleType.MODIFY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OgcMessage)) {
            return false;
        }
        OgcMessage other = (OgcMessage)obj;
        return new EqualsBuilder().append((Object)this.getService(), (Object)other.getService()).append((Object)this.getOperation(), (Object)other.getOperation()).append((Object)this.getEndPoint(), (Object)other.getEndPoint()).append((Object)this.getRequestRule(), (Object)other.getRequestRule()).append((Object)this.getResponseRule(), (Object)other.getResponseRule()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(83, 61).appendSuper(super.hashCode()).append((Object)this.getService()).append((Object)this.getOperation()).append((Object)this.getEndPoint()).append((Object)this.getRequestRule()).append((Object)this.getResponseRule()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("service", (Object)this.getService()).append("operation", (Object)this.getOperation()).append("endPoint", (Object)this.getEndPoint()).append("requestRule", (Object)this.getRequestRule()).append("responseRule", (Object)this.getResponseRule()).toString();
    }
}

