/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.util.interceptor.standard;

import de.terrestris.shoguncore.dao.LayerDataSourceDao;
import de.terrestris.shoguncore.model.layer.source.ImageWmsLayerDataSource;
import de.terrestris.shoguncore.util.interceptor.MutableHttpServletRequest;
import de.terrestris.shoguncore.util.interceptor.WmsRequestInterceptorInterface;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class WmsRequestInterceptor
implements WmsRequestInterceptorInterface {
    @Autowired
    @Qualifier(value="layerDataSourceDao")
    private LayerDataSourceDao<ImageWmsLayerDataSource> layerDataSourceDao;

    private void filterLayerParameter(String name, MutableHttpServletRequest request) {
        String endpoint = request.getParameterIgnoreCase("CUSTOM_ENDPOINT");
        if (endpoint == null) {
            return;
        }
        String layers = request.getParameterIgnoreCase(name);
        String[] fromRequest = layers.split(",");
        LogicalExpression where = Restrictions.and((Criterion)Restrictions.eq((String)"requestableByPath", (Object)true), (Criterion)Restrictions.eq((String)"customRequestPath", (Object)endpoint));
        List sources = this.layerDataSourceDao.findByCriteria(new Criterion[]{where});
        List layersInPath = sources.parallelStream().map(ImageWmsLayerDataSource::getLayerNames).collect(Collectors.toList());
        List resultLayers = Arrays.stream(fromRequest).filter(layersInPath::contains).collect(Collectors.toList());
        request.setParameter(name, resultLayers.stream().reduce("", (acc, val) -> acc.isEmpty() ? val : acc + "," + val));
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public MutableHttpServletRequest interceptGetMap(MutableHttpServletRequest request) {
        this.filterLayerParameter("LAYERS", request);
        return request;
    }

    @Override
    public MutableHttpServletRequest interceptGetCapabilities(MutableHttpServletRequest request) {
        return request;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public MutableHttpServletRequest interceptGetFeatureInfo(MutableHttpServletRequest request) {
        this.filterLayerParameter("LAYERS", request);
        this.filterLayerParameter("QUERY_LAYERS", request);
        return request;
    }

    @Override
    public MutableHttpServletRequest interceptDescribeLayer(MutableHttpServletRequest request) {
        return request;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public MutableHttpServletRequest interceptGetLegendGraphic(MutableHttpServletRequest request) {
        this.filterLayerParameter("LAYER", request);
        return request;
    }

    @Override
    public MutableHttpServletRequest interceptGetStyles(MutableHttpServletRequest request) {
        return request;
    }
}

