/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.web;

import de.terrestris.shoguncore.dao.MapDao;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.service.MapService;
import de.terrestris.shoguncore.util.data.ResultSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/maps"})
public class MapController<E extends de.terrestris.shoguncore.model.module.Map, D extends MapDao<E>, S extends MapService<E, D>> {
    public static final String COULD_NOT_SET_ERROR_MSG = "Could not set layers for Map";
    protected S service;

    public MapController() {
        this(de.terrestris.shoguncore.model.module.Map.class);
    }

    protected MapController(Class<E> type) {
    }

    @Autowired
    @Qualifier(value="mapService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"/setLayersForMap.action"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> setLayersForMap(@RequestParam(value="mapModuleId") Integer mapModuleId, @RequestParam(value="layerIds") List<Integer> layerIds) {
        try {
            if (mapModuleId == null || layerIds == null || layerIds.isEmpty()) {
                throw new Exception();
            }
            List<Layer> layers = ((MapService)this.service).setLayersForMap(mapModuleId, layerIds);
            return ResultSet.success(layers);
        }
        catch (Exception e) {
            return ResultSet.error(COULD_NOT_SET_ERROR_MSG);
        }
    }
}

