/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.helper;

import de.terrestris.shoguncore.model.PersistentObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.ReadableDateTime;

public class CreatedHelper {
    private static final Logger logger = LogManager.getLogger(CreatedHelper.class);

    public static final void setCreatedOnPersistentObject(PersistentObject persistentObject, ReadableDateTime created) throws NoSuchFieldException, IllegalAccessException {
        Field createdField = PersistentObject.class.getDeclaredField("created");
        AccessController.doPrivileged(() -> {
            createdField.setAccessible(true);
            try {
                createdField.set(persistentObject, created);
            }
            catch (IllegalAccessException e) {
                logger.error("Could not set CREATED field for persistent object", (Throwable)e);
            }
            createdField.setAccessible(false);
            return null;
        });
    }
}

