/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.hibernate;

import de.terrestris.shoguncore.util.json.ShogunCoreJsonObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Converter(autoApply=true)
public class SimpleJsonbConverter
implements AttributeConverter<Map<String, String>, String> {
    private static final Logger LOG = LogManager.getLogger(SimpleJsonbConverter.class);

    public String convertToDatabaseColumn(Map<String, String> attribute) {
        ShogunCoreJsonObjectMapper mapper = new ShogunCoreJsonObjectMapper();
        try {
            return mapper.writeValueAsString(attribute);
        }
        catch (Exception e) {
            LOG.warn("Could not convert JSON value to PostgreSQL format: " + e.getMessage());
            LOG.debug("Stack trace: " + e.toString());
            return "{}";
        }
    }

    public Map<String, String> convertToEntityAttribute(String dbData) {
        ShogunCoreJsonObjectMapper parser = new ShogunCoreJsonObjectMapper();
        try {
            return (Map)parser.readValue(dbData, HashMap.class);
        }
        catch (IOException e) {
            LOG.warn("Could not convert JSON value from PostgreSQL format: " + e.getMessage());
            LOG.debug("Stack trace: " + e.toString());
            return new HashMap<String, String>();
        }
    }
}

