/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.module;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.terrestris.shoguncore.converter.LayerIdResolver;
import de.terrestris.shoguncore.model.layer.Layer;
import de.terrestris.shoguncore.model.module.Module;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table
@Cacheable
public class WfsSearch
extends Module {
    private static final long serialVersionUID = 1L;
    private String wfsServerUrl;
    private Integer minSearchTextChars;
    private Integer typeDelay;
    private String groupHeaderTpl;
    @ManyToMany
    @JoinTable(joinColumns={@JoinColumn(name="WFSSEARCH_ID")}, inverseJoinColumns={@JoinColumn(name="LAYER_ID")})
    @OrderColumn(name="IDX")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", resolver=LayerIdResolver.class)
    @JsonIdentityReference(alwaysAsId=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private List<Layer> layers = new ArrayList<Layer>();
    @ElementCollection
    @CollectionTable(name="WFSSEARCHES_FEATUREDATATYPES", joinColumns={@JoinColumn(name="WFSSEARCH_ID")})
    @Column(name="FEATUREDATATYPE")
    @OrderColumn(name="IDX")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private List<String> allowedFeatureTypeDataTypes = new ArrayList<String>();

    public String getWfsServerUrl() {
        return this.wfsServerUrl;
    }

    public void setWfsServerUrl(String wfsServerUrl) {
        this.wfsServerUrl = wfsServerUrl;
    }

    public Integer getMinSearchTextChars() {
        return this.minSearchTextChars;
    }

    public void setMinSearchTextChars(Integer minSearchTextChars) {
        this.minSearchTextChars = minSearchTextChars;
    }

    public Integer getTypeDelay() {
        return this.typeDelay;
    }

    public void setTypeDelay(Integer typeDelay) {
        this.typeDelay = typeDelay;
    }

    public String getGroupHeaderTpl() {
        return this.groupHeaderTpl;
    }

    public void setGroupHeaderTpl(String groupHeaderTpl) {
        this.groupHeaderTpl = groupHeaderTpl;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public List<String> getAllowedFeatureTypeDataTypes() {
        return this.allowedFeatureTypeDataTypes;
    }

    public void setAllowedFeatureTypeDataTypes(List<String> allowedFeatureTypeDataTypes) {
        this.allowedFeatureTypeDataTypes = allowedFeatureTypeDataTypes;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(37, 3).appendSuper(super.hashCode()).append((Object)this.getWfsServerUrl()).append((Object)this.getMinSearchTextChars()).append((Object)this.getTypeDelay()).append((Object)this.getGroupHeaderTpl()).append(this.getLayers()).append(this.getAllowedFeatureTypeDataTypes()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WfsSearch)) {
            return false;
        }
        WfsSearch other = (WfsSearch)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getWfsServerUrl(), (Object)other.getWfsServerUrl()).append((Object)this.getMinSearchTextChars(), (Object)other.getMinSearchTextChars()).append((Object)this.getTypeDelay(), (Object)other.getTypeDelay()).append((Object)this.getGroupHeaderTpl(), (Object)other.getGroupHeaderTpl()).append(this.getLayers(), other.getLayers()).append(this.getAllowedFeatureTypeDataTypes(), other.getAllowedFeatureTypeDataTypes()).isEquals();
    }
}

