/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.security;

import de.terrestris.shoguncore.dao.UserDao;
import de.terrestris.shoguncore.model.Role;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Transactional;

public class ShogunCoreAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LogManager.getLogger(ShogunCoreAuthenticationProvider.class);
    @Autowired
    private UserDao<User> userDao;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @Transactional(value="transactionManager", readOnly=true)
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String exceptionMessage = "User and password do not match.";
        String accountName = authentication.getName();
        String rawPassword = (String)authentication.getCredentials();
        LOG.debug("Trying to authenticate User '" + accountName + "'");
        User user = this.userDao.findByAccountName(accountName);
        HashSet<GrantedAuthority> grantedAuthorities = new HashSet<GrantedAuthority>();
        String encryptedPassword = null;
        if (user == null) {
            LOG.warn("No user for account name '" + accountName + "' could be found.");
            throw new UsernameNotFoundException("User and password do not match.");
        }
        if (!user.isActive()) {
            LOG.warn("The user with the account name '" + accountName + "' is not active.");
            throw new DisabledException("User and password do not match.");
        }
        encryptedPassword = user.getPassword();
        if (this.passwordEncoder.matches((CharSequence)rawPassword, encryptedPassword)) {
            Set<Role> allUserRoles = this.getAllUserRoles(user);
            for (Role role : allUserRoles) {
                grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(role.getName()));
            }
        } else {
            LOG.warn("The given password for user '" + accountName + "' does not match.");
            throw new BadCredentialsException("User and password do not match.");
        }
        UsernamePasswordAuthenticationToken authResult = null;
        if (grantedAuthorities.isEmpty()) {
            LOG.warn("The user '" + accountName + "' has no authorities and will thereby NOT be authenticated.");
            authResult = new UsernamePasswordAuthenticationToken((Object)user, (Object)encryptedPassword);
        } else {
            authResult = new UsernamePasswordAuthenticationToken((Object)user, (Object)encryptedPassword, grantedAuthorities);
            LOG.debug("The user '" + accountName + "' got the following (explicit) roles: " + StringUtils.join(this.getRawRoleNames(grantedAuthorities), (String)", "));
        }
        boolean isAuthenticated = authResult.isAuthenticated();
        String authLog = isAuthenticated ? "has succesfully" : "has NOT";
        LOG.info("The user '" + accountName + "' " + authLog + " been authenticated.");
        return authResult;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Set<Role> getAllUserRoles(User user) {
        HashSet<Role> allUserRoles = new HashSet<Role>();
        if (user == null) {
            return allUserRoles;
        }
        allUserRoles.addAll(user.getRoles());
        Set<UserGroup> userGroups = user.getUserGroups();
        if (userGroups != null) {
            for (UserGroup userGroup : userGroups) {
                allUserRoles.addAll(userGroup.getRoles());
            }
        }
        return allUserRoles;
    }

    private Set<String> getRawRoleNames(Set<GrantedAuthority> grantedAuthorities) {
        HashSet<String> grantedRoles = new HashSet<String>();
        for (GrantedAuthority auth : grantedAuthorities) {
            grantedRoles.add(auth.getAuthority());
        }
        return grantedRoles;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }
}

