/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.AbstractUserTokenDao;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.token.Token;
import de.terrestris.shoguncore.model.token.UserToken;
import de.terrestris.shoguncore.service.AbstractTokenService;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractUserTokenService<E extends UserToken, D extends AbstractUserTokenDao<E>>
extends AbstractTokenService<E, D> {
    private static final int EXPIRY_THRESHOLD_MINUTES = 5;

    public AbstractUserTokenService() {
        this(UserToken.class);
    }

    protected AbstractUserTokenService(Class<E> entityClass) {
        super(entityClass);
    }

    protected abstract E buildConcreteInstance(User var1, Integer var2);

    @Transactional(readOnly=true)
    public E findByUser(User user) {
        SimpleExpression eqUser = Restrictions.eq((String)"user", (Object)user);
        UserToken userToken = (UserToken)((AbstractUserTokenDao)this.dao).findByUniqueCriteria(new Criterion[]{eqUser});
        return (E)userToken;
    }

    @Override
    @Transactional(readOnly=true)
    public void validateToken(E userToken) throws Exception {
        super.validateToken(userToken);
        if (((UserToken)userToken).getUser() == null) {
            throw new Exception("There is no user associated with this token.");
        }
    }

    protected E getValidTokenForUser(User user, Integer expirationTimeInMinutes) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        E userToken = this.findByUser(user);
        if (userToken != null) {
            if (((Token)userToken).expiresWithin(5)) {
                logger.debug("User already has an expired token (or at least a token that expires within the next 5 minutes). This token will be deleted.");
                ((AbstractUserTokenDao)this.dao).delete(userToken);
            } else {
                logger.debug("Returning existing token for user '" + user.getAccountName() + "'");
                return userToken;
            }
        }
        userToken = this.buildConcreteInstance(user, expirationTimeInMinutes);
        ((AbstractUserTokenDao)this.dao).saveOrUpdate(userToken);
        String tokenType = userToken.getClass().getSimpleName();
        logger.debug("Successfully created a user token of type '" + tokenType + "' for user '" + user.getAccountName() + "'");
        return userToken;
    }
}

