/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.web;

import de.terrestris.shoguncore.dao.ImageFileDao;
import de.terrestris.shoguncore.model.ImageFile;
import de.terrestris.shoguncore.service.ImageFileService;
import de.terrestris.shoguncore.util.data.ResultSet;
import de.terrestris.shoguncore.web.FileController;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/image"})
public class ImageFileController<E extends ImageFile, D extends ImageFileDao<E>, S extends ImageFileService<E, D>>
extends FileController<E, D, S> {
    public ImageFileController() {
        this(ImageFile.class);
    }

    protected ImageFileController(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="imageFileService")
    public void setService(S service) {
        this.service = service;
    }

    @RequestMapping(value={"/getThumbnail.action"}, method={RequestMethod.GET})
    public ResponseEntity<?> getThumbnail(@RequestParam Integer id) {
        HttpHeaders responseHeaders = new HttpHeaders();
        try {
            ImageFile image = (ImageFile)((ImageFileService)this.service).findById(id);
            if (image == null) {
                throw new Exception("Could not find the image with id " + id);
            }
            byte[] imageBytes = null;
            imageBytes = image.getThumbnail();
            responseHeaders.setContentType(MediaType.parseMediaType((String)image.getFileType()));
            logger.info("Successfully got the image thumbnail " + image.getFileName());
            return new ResponseEntity((Object)imageBytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            String errorMessage = "Could not get the image thumbnail: " + e.getMessage();
            logger.error(errorMessage);
            Map<String, Object> responseMap = ResultSet.error(errorMessage);
            responseHeaders.setContentType(MediaType.APPLICATION_JSON);
            return new ResponseEntity(responseMap, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
    }
}

