/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.dao;

import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.paging.PagingResult;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class GenericHibernateDao<E extends PersistentObject, ID extends Serializable> {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private Class<E> clazz;
    @Autowired
    private SessionFactory sessionFactory;

    protected GenericHibernateDao(Class<E> clazz) {
        this.clazz = clazz;
    }

    private Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public E findById(ID id) {
        this.LOG.trace((Object)("Finding " + this.clazz.getSimpleName() + " with ID " + id));
        return (E)((PersistentObject)this.getSession().get(this.clazz, id));
    }

    public E loadById(ID id) {
        this.LOG.trace((Object)("Loading " + this.clazz.getSimpleName() + " with ID " + id));
        return (E)((PersistentObject)this.getSession().load(this.clazz, id));
    }

    public List<E> findAll() throws HibernateException {
        this.LOG.trace((Object)("Finding all instances of " + this.clazz.getSimpleName()));
        return this.findByCriteria(new Criterion[0]);
    }

    public void saveOrUpdate(E e) {
        Integer id = e.getId();
        boolean hasId = id != null;
        String createOrUpdatePrefix = hasId ? "Updating" : "Creating a new";
        String idSuffix = hasId ? "with ID " + id : "";
        this.LOG.trace((Object)(createOrUpdatePrefix + " instance of " + this.clazz.getSimpleName() + idSuffix));
        e.setModified((ReadableDateTime)DateTime.now());
        this.getSession().saveOrUpdate(e);
    }

    public void delete(E e) {
        this.LOG.trace((Object)("Deleting " + this.clazz.getSimpleName() + " with ID " + e.getId()));
        this.getSession().delete(e);
    }

    public List<E> findByCriteria(Criterion ... criterion) throws HibernateException {
        this.LOG.trace((Object)("Finding instances of " + this.clazz.getSimpleName() + " based on " + criterion.length + " criteria"));
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        return criteria.list();
    }

    public E findByUniqueCriteria(Criterion ... criterion) throws HibernateException {
        this.LOG.trace((Object)("Finding one unique " + this.clazz.getSimpleName() + " based on " + criterion.length + " criteria"));
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        return (E)((PersistentObject)criteria.uniqueResult());
    }

    public PagingResult<E> findByCriteriaWithSortingAndPaging(Integer firstResult, Integer maxResults, List<Order> sorters, Criterion ... criterion) throws HibernateException {
        int nrOfSorters = sorters == null ? 0 : sorters.size();
        this.LOG.trace((Object)("Finding instances of " + this.clazz.getSimpleName() + " based on " + criterion.length + " criteria" + " with " + nrOfSorters + " sorters"));
        Criteria criteria = this.createDistinctRootEntityCriteria(criterion);
        if (maxResults != null) {
            this.LOG.trace((Object)("Limiting result set size to " + maxResults));
            criteria.setMaxResults(maxResults.intValue());
        }
        if (firstResult != null) {
            this.LOG.trace((Object)("Setting the first result to be retrieved to " + firstResult));
            criteria.setFirstResult(firstResult.intValue());
        }
        if (sorters != null) {
            for (Order sortInfo : sorters) {
                criteria.addOrder(sortInfo);
            }
        }
        return new PagingResult(criteria.list(), this.getTotalCount(criterion));
    }

    protected Criteria createDistinctRootEntityCriteria(Criterion ... criterion) {
        Criteria criteria = this.getSession().createCriteria(this.clazz);
        this.addCriterionsToCriteria(criteria, criterion);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria;
    }

    private Number getTotalCount(Criterion ... criterion) throws HibernateException {
        Criteria criteria = this.getSession().createCriteria(this.clazz);
        this.addCriterionsToCriteria(criteria, criterion);
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }

    private void addCriterionsToCriteria(Criteria criteria, Criterion ... criterion) {
        if (criteria != null) {
            for (Criterion c : criterion) {
                if (c == null) continue;
                criteria.add(c);
            }
        }
    }
}

